/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.services.qldb.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDigestResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, GetDigestResponse> {
    private static final SdkField<SdkBytes> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Digest").getter(GetDigestResponse.getter(GetDigestResponse::digest)).setter(GetDigestResponse.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Digest").build()}).build();
    private static final SdkField<ValueHolder> DIGEST_TIP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DigestTipAddress").getter(GetDigestResponse.getter(GetDigestResponse::digestTipAddress)).setter(GetDigestResponse.setter(Builder::digestTipAddress)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestTipAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGEST_FIELD, DIGEST_TIP_ADDRESS_FIELD));
    private final SdkBytes digest;
    private final ValueHolder digestTipAddress;

    private GetDigestResponse(BuilderImpl builder) {
        super(builder);
        this.digest = builder.digest;
        this.digestTipAddress = builder.digestTipAddress;
    }

    public final SdkBytes digest() {
        return this.digest;
    }

    public final ValueHolder digestTipAddress() {
        return this.digestTipAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.digestTipAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDigestResponse)) {
            return false;
        }
        GetDigestResponse other = (GetDigestResponse)((Object)obj);
        return Objects.equals(this.digest(), other.digest()) && Objects.equals(this.digestTipAddress(), other.digestTipAddress());
    }

    public final String toString() {
        return ToString.builder((String)"GetDigestResponse").add("Digest", (Object)this.digest()).add("DigestTipAddress", (Object)(this.digestTipAddress() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "DigestTipAddress": {
                return Optional.ofNullable(clazz.cast(this.digestTipAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDigestResponse, T> g) {
        return obj -> g.apply((GetDigestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private SdkBytes digest;
        private ValueHolder digestTipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDigestResponse model) {
            super(model);
            this.digest(model.digest);
            this.digestTipAddress(model.digestTipAddress);
        }

        public final ByteBuffer getDigest() {
            return this.digest == null ? null : this.digest.asByteBuffer();
        }

        public final void setDigest(ByteBuffer digest) {
            this.digest(digest == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)digest));
        }

        @Override
        public final Builder digest(SdkBytes digest) {
            this.digest = digest;
            return this;
        }

        public final ValueHolder.Builder getDigestTipAddress() {
            return this.digestTipAddress != null ? this.digestTipAddress.toBuilder() : null;
        }

        public final void setDigestTipAddress(ValueHolder.BuilderImpl digestTipAddress) {
            this.digestTipAddress = digestTipAddress != null ? digestTipAddress.build() : null;
        }

        @Override
        public final Builder digestTipAddress(ValueHolder digestTipAddress) {
            this.digestTipAddress = digestTipAddress;
            return this;
        }

        @Override
        public GetDigestResponse build() {
            return new GetDigestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDigestResponse> {
        public Builder digest(SdkBytes var1);

        public Builder digestTipAddress(ValueHolder var1);

        default public Builder digestTipAddress(Consumer<ValueHolder.Builder> digestTipAddress) {
            return this.digestTipAddress((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(digestTipAddress)).build());
        }
    }
}

