/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed information about a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Deployment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(Deployment::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(Deployment::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Deployment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(Deployment::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatusMessage").getter(getter(Deployment::deploymentStatusMessage))
            .setter(setter(Builder::deploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(Deployment::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Deployment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<DeploymentState> INITIAL_STATE_FIELD = SdkField
            .<DeploymentState> builder(MarshallingType.SDK_POJO).memberName("initialState")
            .getter(getter(Deployment::initialState)).setter(setter(Builder::initialState)).constructor(DeploymentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialState").build()).build();

    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastAttemptedDeploymentId").getter(getter(Deployment::lastAttemptedDeploymentId))
            .setter(setter(Builder::lastAttemptedDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(Deployment::lastModifiedAt)).setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastSucceededDeploymentId").getter(getter(Deployment::lastSucceededDeploymentId))
            .setter(setter(Builder::lastSucceededDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build())
            .build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(Deployment::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(Deployment::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(Deployment::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<Instant> TARGET_RESOURCE_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("targetResourceCreatedAt").getter(getter(Deployment::targetResourceCreatedAt))
            .setter(setter(Builder::targetResourceCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceCreatedAt").build())
            .build();

    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceType").getter(getter(Deployment::targetResourceTypeAsString))
            .setter(setter(Builder::targetResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build())
            .build();

    private static final SdkField<DeploymentState> TARGET_STATE_FIELD = SdkField
            .<DeploymentState> builder(MarshallingType.SDK_POJO).memberName("targetState")
            .getter(getter(Deployment::targetState)).setter(setter(Builder::targetState)).constructor(DeploymentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPLETED_AT_FIELD,
            COMPONENT_NAME_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD,
            ENVIRONMENT_NAME_FIELD, ID_FIELD, INITIAL_STATE_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_MODIFIED_AT_FIELD,
            LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, TARGET_ARN_FIELD,
            TARGET_RESOURCE_CREATED_AT_FIELD, TARGET_RESOURCE_TYPE_FIELD, TARGET_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant completedAt;

    private final String componentName;

    private final Instant createdAt;

    private final String deploymentStatus;

    private final String deploymentStatusMessage;

    private final String environmentName;

    private final String id;

    private final DeploymentState initialState;

    private final String lastAttemptedDeploymentId;

    private final Instant lastModifiedAt;

    private final String lastSucceededDeploymentId;

    private final String serviceInstanceName;

    private final String serviceName;

    private final String targetArn;

    private final Instant targetResourceCreatedAt;

    private final String targetResourceType;

    private final DeploymentState targetState;

    private Deployment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.completedAt = builder.completedAt;
        this.componentName = builder.componentName;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.initialState = builder.initialState;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.targetArn = builder.targetArn;
        this.targetResourceCreatedAt = builder.targetResourceCreatedAt;
        this.targetResourceType = builder.targetResourceType;
        this.targetState = builder.targetState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deployment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time the deployment was completed.
     * </p>
     * 
     * @return The date and time the deployment was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The name of the component associated with this deployment.
     * </p>
     * 
     * @return The name of the component associated with this deployment.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The date and time the deployment was created.
     * </p>
     * 
     * @return The date and time the deployment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The deployment status message.
     * </p>
     * 
     * @return The deployment status message.
     */
    public final String deploymentStatusMessage() {
        return deploymentStatusMessage;
    }

    /**
     * <p>
     * The name of the environment associated with this deployment.
     * </p>
     * 
     * @return The name of the environment associated with this deployment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The initial state of the target resource at the time of the deployment.
     * </p>
     * 
     * @return The initial state of the target resource at the time of the deployment.
     */
    public final DeploymentState initialState() {
        return initialState;
    }

    /**
     * <p>
     * The ID of the last attempted deployment.
     * </p>
     * 
     * @return The ID of the last attempted deployment.
     */
    public final String lastAttemptedDeploymentId() {
        return lastAttemptedDeploymentId;
    }

    /**
     * <p>
     * The date and time the deployment was last modified.
     * </p>
     * 
     * @return The date and time the deployment was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The ID of the last successful deployment.
     * </p>
     * 
     * @return The ID of the last successful deployment.
     */
    public final String lastSucceededDeploymentId() {
        return lastSucceededDeploymentId;
    }

    /**
     * <p>
     * The name of the deployment's service instance.
     * </p>
     * 
     * @return The name of the deployment's service instance.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service in this deployment.
     * </p>
     * 
     * @return The name of the service in this deployment.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target of the deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target of the deployment.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The date and time the depoyment target was created.
     * </p>
     * 
     * @return The date and time the depoyment target was created.
     */
    public final Instant targetResourceCreatedAt() {
        return targetResourceCreatedAt;
    }

    /**
     * <p>
     * The resource type of the deployment target. It can be an environment, service, service instance, or component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link DeploymentTargetResourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the deployment target. It can be an environment, service, service instance, or
     *         component.
     * @see DeploymentTargetResourceType
     */
    public final DeploymentTargetResourceType targetResourceType() {
        return DeploymentTargetResourceType.fromValue(targetResourceType);
    }

    /**
     * <p>
     * The resource type of the deployment target. It can be an environment, service, service instance, or component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link DeploymentTargetResourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the deployment target. It can be an environment, service, service instance, or
     *         component.
     * @see DeploymentTargetResourceType
     */
    public final String targetResourceTypeAsString() {
        return targetResourceType;
    }

    /**
     * <p>
     * The target state of the target resource at the time of the deployment.
     * </p>
     * 
     * @return The target state of the target resource at the time of the deployment.
     */
    public final DeploymentState targetState() {
        return targetState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(initialState());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(componentName(), other.componentName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentStatusMessage(), other.deploymentStatusMessage())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(id(), other.id())
                && Objects.equals(initialState(), other.initialState())
                && Objects.equals(lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(lastSucceededDeploymentId(), other.lastSucceededDeploymentId())
                && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(targetResourceCreatedAt(), other.targetResourceCreatedAt())
                && Objects.equals(targetResourceTypeAsString(), other.targetResourceTypeAsString())
                && Objects.equals(targetState(), other.targetState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Deployment").add("Arn", arn()).add("CompletedAt", completedAt())
                .add("ComponentName", componentName()).add("CreatedAt", createdAt())
                .add("DeploymentStatus", deploymentStatusAsString())
                .add("DeploymentStatusMessage", deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentName", environmentName()).add("Id", id()).add("InitialState", initialState())
                .add("LastAttemptedDeploymentId", lastAttemptedDeploymentId()).add("LastModifiedAt", lastModifiedAt())
                .add("LastSucceededDeploymentId", lastSucceededDeploymentId()).add("ServiceInstanceName", serviceInstanceName())
                .add("ServiceName", serviceName()).add("TargetArn", targetArn())
                .add("TargetResourceCreatedAt", targetResourceCreatedAt())
                .add("TargetResourceType", targetResourceTypeAsString()).add("TargetState", targetState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "deploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessage()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "initialState":
            return Optional.ofNullable(clazz.cast(initialState()));
        case "lastAttemptedDeploymentId":
            return Optional.ofNullable(clazz.cast(lastAttemptedDeploymentId()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "lastSucceededDeploymentId":
            return Optional.ofNullable(clazz.cast(lastSucceededDeploymentId()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "targetResourceCreatedAt":
            return Optional.ofNullable(clazz.cast(targetResourceCreatedAt()));
        case "targetResourceType":
            return Optional.ofNullable(clazz.cast(targetResourceTypeAsString()));
        case "targetState":
            return Optional.ofNullable(clazz.cast(targetState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deployment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time the deployment was completed.
         * </p>
         * 
         * @param completedAt
         *        The date and time the deployment was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * The name of the component associated with this deployment.
         * </p>
         * 
         * @param componentName
         *        The name of the component associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The date and time the deployment was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * The deployment status message.
         * </p>
         * 
         * @param deploymentStatusMessage
         *        The deployment status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessage(String deploymentStatusMessage);

        /**
         * <p>
         * The name of the environment associated with this deployment.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param id
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The initial state of the target resource at the time of the deployment.
         * </p>
         * 
         * @param initialState
         *        The initial state of the target resource at the time of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialState(DeploymentState initialState);

        /**
         * <p>
         * The initial state of the target resource at the time of the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentState.Builder} avoiding the
         * need to create one manually via {@link DeploymentState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentState.Builder#build()} is called immediately and its
         * result is passed to {@link #initialState(DeploymentState)}.
         * 
         * @param initialState
         *        a consumer that will call methods on {@link DeploymentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialState(DeploymentState)
         */
        default Builder initialState(Consumer<DeploymentState.Builder> initialState) {
            return initialState(DeploymentState.builder().applyMutation(initialState).build());
        }

        /**
         * <p>
         * The ID of the last attempted deployment.
         * </p>
         * 
         * @param lastAttemptedDeploymentId
         *        The ID of the last attempted deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId);

        /**
         * <p>
         * The date and time the deployment was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time the deployment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The ID of the last successful deployment.
         * </p>
         * 
         * @param lastSucceededDeploymentId
         *        The ID of the last successful deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSucceededDeploymentId(String lastSucceededDeploymentId);

        /**
         * <p>
         * The name of the deployment's service instance.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the deployment's service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service in this deployment.
         * </p>
         * 
         * @param serviceName
         *        The name of the service in this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target of the deployment.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the target of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The date and time the depoyment target was created.
         * </p>
         * 
         * @param targetResourceCreatedAt
         *        The date and time the depoyment target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceCreatedAt(Instant targetResourceCreatedAt);

        /**
         * <p>
         * The resource type of the deployment target. It can be an environment, service, service instance, or
         * component.
         * </p>
         * 
         * @param targetResourceType
         *        The resource type of the deployment target. It can be an environment, service, service instance, or
         *        component.
         * @see DeploymentTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTargetResourceType
         */
        Builder targetResourceType(String targetResourceType);

        /**
         * <p>
         * The resource type of the deployment target. It can be an environment, service, service instance, or
         * component.
         * </p>
         * 
         * @param targetResourceType
         *        The resource type of the deployment target. It can be an environment, service, service instance, or
         *        component.
         * @see DeploymentTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTargetResourceType
         */
        Builder targetResourceType(DeploymentTargetResourceType targetResourceType);

        /**
         * <p>
         * The target state of the target resource at the time of the deployment.
         * </p>
         * 
         * @param targetState
         *        The target state of the target resource at the time of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetState(DeploymentState targetState);

        /**
         * <p>
         * The target state of the target resource at the time of the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentState.Builder} avoiding the
         * need to create one manually via {@link DeploymentState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentState.Builder#build()} is called immediately and its
         * result is passed to {@link #targetState(DeploymentState)}.
         * 
         * @param targetState
         *        a consumer that will call methods on {@link DeploymentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetState(DeploymentState)
         */
        default Builder targetState(Consumer<DeploymentState.Builder> targetState) {
            return targetState(DeploymentState.builder().applyMutation(targetState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant completedAt;

        private String componentName;

        private Instant createdAt;

        private String deploymentStatus;

        private String deploymentStatusMessage;

        private String environmentName;

        private String id;

        private DeploymentState initialState;

        private String lastAttemptedDeploymentId;

        private Instant lastModifiedAt;

        private String lastSucceededDeploymentId;

        private String serviceInstanceName;

        private String serviceName;

        private String targetArn;

        private Instant targetResourceCreatedAt;

        private String targetResourceType;

        private DeploymentState targetState;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            arn(model.arn);
            completedAt(model.completedAt);
            componentName(model.componentName);
            createdAt(model.createdAt);
            deploymentStatus(model.deploymentStatus);
            deploymentStatusMessage(model.deploymentStatusMessage);
            environmentName(model.environmentName);
            id(model.id);
            initialState(model.initialState);
            lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            lastModifiedAt(model.lastModifiedAt);
            lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
            targetArn(model.targetArn);
            targetResourceCreatedAt(model.targetResourceCreatedAt);
            targetResourceType(model.targetResourceType);
            targetState(model.targetState);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DeploymentState.Builder getInitialState() {
            return initialState != null ? initialState.toBuilder() : null;
        }

        public final void setInitialState(DeploymentState.BuilderImpl initialState) {
            this.initialState = initialState != null ? initialState.build() : null;
        }

        @Override
        public final Builder initialState(DeploymentState initialState) {
            this.initialState = initialState;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getTargetResourceCreatedAt() {
            return targetResourceCreatedAt;
        }

        public final void setTargetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
        }

        @Override
        public final Builder targetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
            return this;
        }

        public final String getTargetResourceType() {
            return targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(DeploymentTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final DeploymentState.Builder getTargetState() {
            return targetState != null ? targetState.toBuilder() : null;
        }

        public final void setTargetState(DeploymentState.BuilderImpl targetState) {
            this.targetState = targetState != null ? targetState.build() : null;
        }

        @Override
        public final Builder targetState(DeploymentState targetState) {
            this.targetState = targetState;
            return this;
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
