/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceSyncBlockerSummaryResponse extends ProtonResponse implements
        ToCopyableBuilder<GetServiceSyncBlockerSummaryResponse.Builder, GetServiceSyncBlockerSummaryResponse> {
    private static final SdkField<ServiceSyncBlockerSummary> SERVICE_SYNC_BLOCKER_SUMMARY_FIELD = SdkField
            .<ServiceSyncBlockerSummary> builder(MarshallingType.SDK_POJO).memberName("serviceSyncBlockerSummary")
            .getter(getter(GetServiceSyncBlockerSummaryResponse::serviceSyncBlockerSummary))
            .setter(setter(Builder::serviceSyncBlockerSummary)).constructor(ServiceSyncBlockerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSyncBlockerSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_SYNC_BLOCKER_SUMMARY_FIELD));

    private final ServiceSyncBlockerSummary serviceSyncBlockerSummary;

    private GetServiceSyncBlockerSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSyncBlockerSummary = builder.serviceSyncBlockerSummary;
    }

    /**
     * <p>
     * The detailed data of the requested service sync blocker summary.
     * </p>
     * 
     * @return The detailed data of the requested service sync blocker summary.
     */
    public final ServiceSyncBlockerSummary serviceSyncBlockerSummary() {
        return serviceSyncBlockerSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceSyncBlockerSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceSyncBlockerSummaryResponse)) {
            return false;
        }
        GetServiceSyncBlockerSummaryResponse other = (GetServiceSyncBlockerSummaryResponse) obj;
        return Objects.equals(serviceSyncBlockerSummary(), other.serviceSyncBlockerSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceSyncBlockerSummaryResponse")
                .add("ServiceSyncBlockerSummary", serviceSyncBlockerSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceSyncBlockerSummary":
            return Optional.ofNullable(clazz.cast(serviceSyncBlockerSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceSyncBlockerSummaryResponse, T> g) {
        return obj -> g.apply((GetServiceSyncBlockerSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceSyncBlockerSummaryResponse> {
        /**
         * <p>
         * The detailed data of the requested service sync blocker summary.
         * </p>
         * 
         * @param serviceSyncBlockerSummary
         *        The detailed data of the requested service sync blocker summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSyncBlockerSummary(ServiceSyncBlockerSummary serviceSyncBlockerSummary);

        /**
         * <p>
         * The detailed data of the requested service sync blocker summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceSyncBlockerSummary.Builder}
         * avoiding the need to create one manually via {@link ServiceSyncBlockerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceSyncBlockerSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceSyncBlockerSummary(ServiceSyncBlockerSummary)}.
         * 
         * @param serviceSyncBlockerSummary
         *        a consumer that will call methods on {@link ServiceSyncBlockerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSyncBlockerSummary(ServiceSyncBlockerSummary)
         */
        default Builder serviceSyncBlockerSummary(Consumer<ServiceSyncBlockerSummary.Builder> serviceSyncBlockerSummary) {
            return serviceSyncBlockerSummary(ServiceSyncBlockerSummary.builder().applyMutation(serviceSyncBlockerSummary).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private ServiceSyncBlockerSummary serviceSyncBlockerSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceSyncBlockerSummaryResponse model) {
            super(model);
            serviceSyncBlockerSummary(model.serviceSyncBlockerSummary);
        }

        public final ServiceSyncBlockerSummary.Builder getServiceSyncBlockerSummary() {
            return serviceSyncBlockerSummary != null ? serviceSyncBlockerSummary.toBuilder() : null;
        }

        public final void setServiceSyncBlockerSummary(ServiceSyncBlockerSummary.BuilderImpl serviceSyncBlockerSummary) {
            this.serviceSyncBlockerSummary = serviceSyncBlockerSummary != null ? serviceSyncBlockerSummary.build() : null;
        }

        @Override
        public final Builder serviceSyncBlockerSummary(ServiceSyncBlockerSummary serviceSyncBlockerSummary) {
            this.serviceSyncBlockerSummary = serviceSyncBlockerSummary;
            return this;
        }

        @Override
        public GetServiceSyncBlockerSummaryResponse build() {
            return new GetServiceSyncBlockerSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
