/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProvisionedResourceEngine {
    CLOUDFORMATION("CLOUDFORMATION"),
    TERRAFORM("TERRAFORM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProvisionedResourceEngine> VALUE_MAP;
    private final String value;

    private ProvisionedResourceEngine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProvisionedResourceEngine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProvisionedResourceEngine> knownValues() {
        EnumSet<ProvisionedResourceEngine> knownValues = EnumSet.allOf(ProvisionedResourceEngine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProvisionedResourceEngine.class, ProvisionedResourceEngine::toString);
    }
}

