/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary data of an Proton component resource.
 * </p>
 * <p>
 * For more information about components, see <a
 * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the <i>Proton
 * User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentSummary.Builder, ComponentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ComponentSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ComponentSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(ComponentSummary::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatusMessage").getter(getter(ComponentSummary::deploymentStatusMessage))
            .setter(setter(Builder::deploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(ComponentSummary::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastAttemptedDeploymentId").getter(getter(ComponentSummary::lastAttemptedDeploymentId))
            .setter(setter(Builder::lastAttemptedDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentAttemptedAt")
            .getter(getter(ComponentSummary::lastDeploymentAttemptedAt)).setter(setter(Builder::lastDeploymentAttemptedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentAttemptedAt").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentSucceededAt")
            .getter(getter(ComponentSummary::lastDeploymentSucceededAt)).setter(setter(Builder::lastDeploymentSucceededAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentSucceededAt").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(ComponentSummary::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastSucceededDeploymentId").getter(getter(ComponentSummary::lastSucceededDeploymentId))
            .setter(setter(Builder::lastSucceededDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComponentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName").getter(getter(ComponentSummary::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ComponentSummary::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, ENVIRONMENT_NAME_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD,
            LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD, LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD, LAST_MODIFIED_AT_FIELD,
            LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, NAME_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String deploymentStatus;

    private final String deploymentStatusMessage;

    private final String environmentName;

    private final String lastAttemptedDeploymentId;

    private final Instant lastDeploymentAttemptedAt;

    private final Instant lastDeploymentSucceededAt;

    private final Instant lastModifiedAt;

    private final String lastSucceededDeploymentId;

    private final String name;

    private final String serviceInstanceName;

    private final String serviceName;

    private ComponentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.environmentName = builder.environmentName;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastDeploymentAttemptedAt = builder.lastDeploymentAttemptedAt;
        this.lastDeploymentSucceededAt = builder.lastDeploymentSucceededAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.name = builder.name;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the component was created.
     * </p>
     * 
     * @return The time when the component was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The component deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The component deployment status.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The component deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The component deployment status.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The message associated with the component deployment status.
     * </p>
     * 
     * @return The message associated with the component deployment status.
     */
    public final String deploymentStatusMessage() {
        return deploymentStatusMessage;
    }

    /**
     * <p>
     * The name of the Proton environment that this component is associated with.
     * </p>
     * 
     * @return The name of the Proton environment that this component is associated with.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ID of the last attempted deployment of this component.
     * </p>
     * 
     * @return The ID of the last attempted deployment of this component.
     */
    public final String lastAttemptedDeploymentId() {
        return lastAttemptedDeploymentId;
    }

    /**
     * <p>
     * The time when a deployment of the component was last attempted.
     * </p>
     * 
     * @return The time when a deployment of the component was last attempted.
     */
    public final Instant lastDeploymentAttemptedAt() {
        return lastDeploymentAttemptedAt;
    }

    /**
     * <p>
     * The time when the component was last deployed successfully.
     * </p>
     * 
     * @return The time when the component was last deployed successfully.
     */
    public final Instant lastDeploymentSucceededAt() {
        return lastDeploymentSucceededAt;
    }

    /**
     * <p>
     * The time when the component was last modified.
     * </p>
     * 
     * @return The time when the component was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The ID of the last successful deployment of this component.
     * </p>
     * 
     * @return The ID of the last successful deployment of this component.
     */
    public final String lastSucceededDeploymentId() {
        return lastSucceededDeploymentId;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the service instance that this component is attached to. Provided when a component is attached to a
     * service instance.
     * </p>
     * 
     * @return The name of the service instance that this component is attached to. Provided when a component is
     *         attached to a service instance.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component is
     * attached to a service instance.
     * </p>
     * 
     * @return The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a
     *         component is attached to a service instance.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentAttemptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentSucceededAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentStatusMessage(), other.deploymentStatusMessage())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId())
                && Objects.equals(lastDeploymentAttemptedAt(), other.lastDeploymentAttemptedAt())
                && Objects.equals(lastDeploymentSucceededAt(), other.lastDeploymentSucceededAt())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(lastSucceededDeploymentId(), other.lastSucceededDeploymentId())
                && Objects.equals(name(), other.name()) && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("DeploymentStatus", deploymentStatusAsString())
                .add("DeploymentStatusMessage", deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentName", environmentName()).add("LastAttemptedDeploymentId", lastAttemptedDeploymentId())
                .add("LastDeploymentAttemptedAt", lastDeploymentAttemptedAt())
                .add("LastDeploymentSucceededAt", lastDeploymentSucceededAt()).add("LastModifiedAt", lastModifiedAt())
                .add("LastSucceededDeploymentId", lastSucceededDeploymentId()).add("Name", name())
                .add("ServiceInstanceName", serviceInstanceName()).add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "deploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessage()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "lastAttemptedDeploymentId":
            return Optional.ofNullable(clazz.cast(lastAttemptedDeploymentId()));
        case "lastDeploymentAttemptedAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentAttemptedAt()));
        case "lastDeploymentSucceededAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentSucceededAt()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "lastSucceededDeploymentId":
            return Optional.ofNullable(clazz.cast(lastSucceededDeploymentId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentSummary, T> g) {
        return obj -> g.apply((ComponentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the component was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The component deployment status.
         * </p>
         * 
         * @param deploymentStatus
         *        The component deployment status.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The component deployment status.
         * </p>
         * 
         * @param deploymentStatus
         *        The component deployment status.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * The message associated with the component deployment status.
         * </p>
         * 
         * @param deploymentStatusMessage
         *        The message associated with the component deployment status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessage(String deploymentStatusMessage);

        /**
         * <p>
         * The name of the Proton environment that this component is associated with.
         * </p>
         * 
         * @param environmentName
         *        The name of the Proton environment that this component is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ID of the last attempted deployment of this component.
         * </p>
         * 
         * @param lastAttemptedDeploymentId
         *        The ID of the last attempted deployment of this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId);

        /**
         * <p>
         * The time when a deployment of the component was last attempted.
         * </p>
         * 
         * @param lastDeploymentAttemptedAt
         *        The time when a deployment of the component was last attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt);

        /**
         * <p>
         * The time when the component was last deployed successfully.
         * </p>
         * 
         * @param lastDeploymentSucceededAt
         *        The time when the component was last deployed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt);

        /**
         * <p>
         * The time when the component was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the component was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The ID of the last successful deployment of this component.
         * </p>
         * 
         * @param lastSucceededDeploymentId
         *        The ID of the last successful deployment of this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSucceededDeploymentId(String lastSucceededDeploymentId);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param name
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the service instance that this component is attached to. Provided when a component is attached to
         * a service instance.
         * </p>
         * 
         * @param serviceInstanceName
         *        The name of the service instance that this component is attached to. Provided when a component is
         *        attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component
         * is attached to a service instance.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a
         *        component is attached to a service instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String deploymentStatus;

        private String deploymentStatusMessage;

        private String environmentName;

        private String lastAttemptedDeploymentId;

        private Instant lastDeploymentAttemptedAt;

        private Instant lastDeploymentSucceededAt;

        private Instant lastModifiedAt;

        private String lastSucceededDeploymentId;

        private String name;

        private String serviceInstanceName;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            deploymentStatus(model.deploymentStatus);
            deploymentStatusMessage(model.deploymentStatusMessage);
            environmentName(model.environmentName);
            lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            lastDeploymentAttemptedAt(model.lastDeploymentAttemptedAt);
            lastDeploymentSucceededAt(model.lastDeploymentSucceededAt);
            lastModifiedAt(model.lastModifiedAt);
            lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            name(model.name);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastDeploymentAttemptedAt() {
            return lastDeploymentAttemptedAt;
        }

        public final void setLastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
        }

        @Override
        public final Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
            return this;
        }

        public final Instant getLastDeploymentSucceededAt() {
            return lastDeploymentSucceededAt;
        }

        public final void setLastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
        }

        @Override
        public final Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public ComponentSummary build() {
            return new ComponentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
