/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListServicePipelineOutputsIterable
implements SdkIterable<ListServicePipelineOutputsResponse> {
    private final ProtonClient client;
    private final ListServicePipelineOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicePipelineOutputsIterable(ProtonClient client, ListServicePipelineOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServicePipelineOutputsResponseFetcher();
    }

    public Iterator<ListServicePipelineOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Output> outputs() {
        Function<ListServicePipelineOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServicePipelineOutputsResponseFetcher
    implements SyncPageFetcher<ListServicePipelineOutputsResponse> {
        private ListServicePipelineOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePipelineOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicePipelineOutputsResponse nextPage(ListServicePipelineOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListServicePipelineOutputsIterable.this.client.listServicePipelineOutputs(ListServicePipelineOutputsIterable.this.firstRequest);
            }
            return ListServicePipelineOutputsIterable.this.client.listServicePipelineOutputs((ListServicePipelineOutputsRequest)((Object)ListServicePipelineOutputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

