/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksClient;
import software.amazon.awssdk.services.privatenetworks.internal.UserAgentUtils;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResource;

public class ListNetworkResourcesIterable
implements SdkIterable<ListNetworkResourcesResponse> {
    private final PrivateNetworksClient client;
    private final ListNetworkResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworkResourcesIterable(PrivateNetworksClient client, ListNetworkResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworkResourcesResponseFetcher();
    }

    public Iterator<ListNetworkResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkResource> networkResources() {
        Function<ListNetworkResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResources() != null) {
                return response.networkResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNetworkResourcesResponseFetcher
    implements SyncPageFetcher<ListNetworkResourcesResponse> {
        private ListNetworkResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworkResourcesResponse nextPage(ListNetworkResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkResourcesIterable.this.client.listNetworkResources(ListNetworkResourcesIterable.this.firstRequest);
            }
            return ListNetworkResourcesIterable.this.client.listNetworkResources((ListNetworkResourcesRequest)((Object)ListNetworkResourcesIterable.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

