/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the network resources in the order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrderedResourceDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<OrderedResourceDefinition.Builder, OrderedResourceDefinition> {
    private static final SdkField<CommitmentConfiguration> COMMITMENT_CONFIGURATION_FIELD = SdkField
            .<CommitmentConfiguration> builder(MarshallingType.SDK_POJO).memberName("commitmentConfiguration")
            .getter(getter(OrderedResourceDefinition::commitmentConfiguration)).setter(setter(Builder::commitmentConfiguration))
            .constructor(CommitmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentConfiguration").build())
            .build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(OrderedResourceDefinition::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(OrderedResourceDefinition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMMITMENT_CONFIGURATION_FIELD, COUNT_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommitmentConfiguration commitmentConfiguration;

    private final Integer count;

    private final String type;

    private OrderedResourceDefinition(BuilderImpl builder) {
        this.commitmentConfiguration = builder.commitmentConfiguration;
        this.count = builder.count;
        this.type = builder.type;
    }

    /**
     * <p>
     * The duration and renewal status of the commitment period for each radio unit in the order. Does not show details
     * if the resource type is DEVICE_IDENTIFIER.
     * </p>
     * 
     * @return The duration and renewal status of the commitment period for each radio unit in the order. Does not show
     *         details if the resource type is DEVICE_IDENTIFIER.
     */
    public final CommitmentConfiguration commitmentConfiguration() {
        return commitmentConfiguration;
    }

    /**
     * <p>
     * The number of network resources in the order.
     * </p>
     * 
     * @return The number of network resources in the order.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The type of network resource in the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of network resource in the order.
     * @see NetworkResourceDefinitionType
     */
    public final NetworkResourceDefinitionType type() {
        return NetworkResourceDefinitionType.fromValue(type);
    }

    /**
     * <p>
     * The type of network resource in the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of network resource in the order.
     * @see NetworkResourceDefinitionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderedResourceDefinition)) {
            return false;
        }
        OrderedResourceDefinition other = (OrderedResourceDefinition) obj;
        return Objects.equals(commitmentConfiguration(), other.commitmentConfiguration())
                && Objects.equals(count(), other.count()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrderedResourceDefinition").add("CommitmentConfiguration", commitmentConfiguration())
                .add("Count", count()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitmentConfiguration":
            return Optional.ofNullable(clazz.cast(commitmentConfiguration()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderedResourceDefinition, T> g) {
        return obj -> g.apply((OrderedResourceDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrderedResourceDefinition> {
        /**
         * <p>
         * The duration and renewal status of the commitment period for each radio unit in the order. Does not show
         * details if the resource type is DEVICE_IDENTIFIER.
         * </p>
         * 
         * @param commitmentConfiguration
         *        The duration and renewal status of the commitment period for each radio unit in the order. Does not
         *        show details if the resource type is DEVICE_IDENTIFIER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration);

        /**
         * <p>
         * The duration and renewal status of the commitment period for each radio unit in the order. Does not show
         * details if the resource type is DEVICE_IDENTIFIER.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommitmentConfiguration.Builder} avoiding
         * the need to create one manually via {@link CommitmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommitmentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #commitmentConfiguration(CommitmentConfiguration)}.
         * 
         * @param commitmentConfiguration
         *        a consumer that will call methods on {@link CommitmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentConfiguration(CommitmentConfiguration)
         */
        default Builder commitmentConfiguration(Consumer<CommitmentConfiguration.Builder> commitmentConfiguration) {
            return commitmentConfiguration(CommitmentConfiguration.builder().applyMutation(commitmentConfiguration).build());
        }

        /**
         * <p>
         * The number of network resources in the order.
         * </p>
         * 
         * @param count
         *        The number of network resources in the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The type of network resource in the order.
         * </p>
         * 
         * @param type
         *        The type of network resource in the order.
         * @see NetworkResourceDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceDefinitionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of network resource in the order.
         * </p>
         * 
         * @param type
         *        The type of network resource in the order.
         * @see NetworkResourceDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceDefinitionType
         */
        Builder type(NetworkResourceDefinitionType type);
    }

    static final class BuilderImpl implements Builder {
        private CommitmentConfiguration commitmentConfiguration;

        private Integer count;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderedResourceDefinition model) {
            commitmentConfiguration(model.commitmentConfiguration);
            count(model.count);
            type(model.type);
        }

        public final CommitmentConfiguration.Builder getCommitmentConfiguration() {
            return commitmentConfiguration != null ? commitmentConfiguration.toBuilder() : null;
        }

        public final void setCommitmentConfiguration(CommitmentConfiguration.BuilderImpl commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration != null ? commitmentConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkResourceDefinitionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public OrderedResourceDefinition build() {
            return new OrderedResourceDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
