/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a subscriber of a device that can use a network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceIdentifier.Builder, DeviceIdentifier> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DeviceIdentifier::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEVICE_IDENTIFIER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceIdentifierArn").getter(getter(DeviceIdentifier::deviceIdentifierArn))
            .setter(setter(Builder::deviceIdentifierArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifierArn").build())
            .build();

    private static final SdkField<String> ICCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("iccid")
            .getter(getter(DeviceIdentifier::iccid)).setter(setter(Builder::iccid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iccid").build()).build();

    private static final SdkField<String> IMSI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("imsi")
            .getter(getter(DeviceIdentifier::imsi)).setter(setter(Builder::imsi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imsi").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(DeviceIdentifier::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderArn").getter(getter(DeviceIdentifier::orderArn)).setter(setter(Builder::orderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeviceIdentifier::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TRAFFIC_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trafficGroupArn").getter(getter(DeviceIdentifier::trafficGroupArn))
            .setter(setter(Builder::trafficGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficGroupArn").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vendor")
            .getter(getter(DeviceIdentifier::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEVICE_IDENTIFIER_ARN_FIELD, ICCID_FIELD, IMSI_FIELD, NETWORK_ARN_FIELD, ORDER_ARN_FIELD, STATUS_FIELD,
            TRAFFIC_GROUP_ARN_FIELD, VENDOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String deviceIdentifierArn;

    private final String iccid;

    private final String imsi;

    private final String networkArn;

    private final String orderArn;

    private final String status;

    private final String trafficGroupArn;

    private final String vendor;

    private DeviceIdentifier(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deviceIdentifierArn = builder.deviceIdentifierArn;
        this.iccid = builder.iccid;
        this.imsi = builder.imsi;
        this.networkArn = builder.networkArn;
        this.orderArn = builder.orderArn;
        this.status = builder.status;
        this.trafficGroupArn = builder.trafficGroupArn;
        this.vendor = builder.vendor;
    }

    /**
     * <p>
     * The creation time of this device identifier.
     * </p>
     * 
     * @return The creation time of this device identifier.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device identifier.
     */
    public final String deviceIdentifierArn() {
        return deviceIdentifierArn;
    }

    /**
     * <p>
     * The Integrated Circuit Card Identifier of the device identifier.
     * </p>
     * 
     * @return The Integrated Circuit Card Identifier of the device identifier.
     */
    public final String iccid() {
        return iccid;
    }

    /**
     * <p>
     * The International Mobile Subscriber Identity of the device identifier.
     * </p>
     * 
     * @return The International Mobile Subscriber Identity of the device identifier.
     */
    public final String imsi() {
        return imsi;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network on which the device identifier appears.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network on which the device identifier appears.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the order used to purchase the device identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the order used to purchase the device identifier.
     */
    public final String orderArn() {
        return orderArn;
    }

    /**
     * <p>
     * The status of the device identifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceIdentifierStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device identifier.
     * @see DeviceIdentifierStatus
     */
    public final DeviceIdentifierStatus status() {
        return DeviceIdentifierStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the device identifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceIdentifierStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device identifier.
     * @see DeviceIdentifierStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the traffic group to which the device identifier belongs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the traffic group to which the device identifier belongs.
     */
    public final String trafficGroupArn() {
        return trafficGroupArn;
    }

    /**
     * <p>
     * The vendor of the device identifier.
     * </p>
     * 
     * @return The vendor of the device identifier.
     */
    public final String vendor() {
        return vendor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIdentifierArn());
        hashCode = 31 * hashCode + Objects.hashCode(iccid());
        hashCode = 31 * hashCode + Objects.hashCode(imsi());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceIdentifier)) {
            return false;
        }
        DeviceIdentifier other = (DeviceIdentifier) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deviceIdentifierArn(), other.deviceIdentifierArn()) && Objects.equals(iccid(), other.iccid())
                && Objects.equals(imsi(), other.imsi()) && Objects.equals(networkArn(), other.networkArn())
                && Objects.equals(orderArn(), other.orderArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(trafficGroupArn(), other.trafficGroupArn()) && Objects.equals(vendor(), other.vendor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceIdentifier").add("CreatedAt", createdAt())
                .add("DeviceIdentifierArn", deviceIdentifierArn()).add("Iccid", iccid())
                .add("Imsi", imsi() == null ? null : "*** Sensitive Data Redacted ***").add("NetworkArn", networkArn())
                .add("OrderArn", orderArn()).add("Status", statusAsString()).add("TrafficGroupArn", trafficGroupArn())
                .add("Vendor", vendor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deviceIdentifierArn":
            return Optional.ofNullable(clazz.cast(deviceIdentifierArn()));
        case "iccid":
            return Optional.ofNullable(clazz.cast(iccid()));
        case "imsi":
            return Optional.ofNullable(clazz.cast(imsi()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "orderArn":
            return Optional.ofNullable(clazz.cast(orderArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "trafficGroupArn":
            return Optional.ofNullable(clazz.cast(trafficGroupArn()));
        case "vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceIdentifier, T> g) {
        return obj -> g.apply((DeviceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceIdentifier> {
        /**
         * <p>
         * The creation time of this device identifier.
         * </p>
         * 
         * @param createdAt
         *        The creation time of this device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device identifier.
         * </p>
         * 
         * @param deviceIdentifierArn
         *        The Amazon Resource Name (ARN) of the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIdentifierArn(String deviceIdentifierArn);

        /**
         * <p>
         * The Integrated Circuit Card Identifier of the device identifier.
         * </p>
         * 
         * @param iccid
         *        The Integrated Circuit Card Identifier of the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iccid(String iccid);

        /**
         * <p>
         * The International Mobile Subscriber Identity of the device identifier.
         * </p>
         * 
         * @param imsi
         *        The International Mobile Subscriber Identity of the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imsi(String imsi);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network on which the device identifier appears.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network on which the device identifier appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the order used to purchase the device identifier.
         * </p>
         * 
         * @param orderArn
         *        The Amazon Resource Name (ARN) of the order used to purchase the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderArn(String orderArn);

        /**
         * <p>
         * The status of the device identifier.
         * </p>
         * 
         * @param status
         *        The status of the device identifier.
         * @see DeviceIdentifierStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceIdentifierStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the device identifier.
         * </p>
         * 
         * @param status
         *        The status of the device identifier.
         * @see DeviceIdentifierStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceIdentifierStatus
         */
        Builder status(DeviceIdentifierStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the traffic group to which the device identifier belongs.
         * </p>
         * 
         * @param trafficGroupArn
         *        The Amazon Resource Name (ARN) of the traffic group to which the device identifier belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficGroupArn(String trafficGroupArn);

        /**
         * <p>
         * The vendor of the device identifier.
         * </p>
         * 
         * @param vendor
         *        The vendor of the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String deviceIdentifierArn;

        private String iccid;

        private String imsi;

        private String networkArn;

        private String orderArn;

        private String status;

        private String trafficGroupArn;

        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceIdentifier model) {
            createdAt(model.createdAt);
            deviceIdentifierArn(model.deviceIdentifierArn);
            iccid(model.iccid);
            imsi(model.imsi);
            networkArn(model.networkArn);
            orderArn(model.orderArn);
            status(model.status);
            trafficGroupArn(model.trafficGroupArn);
            vendor(model.vendor);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeviceIdentifierArn() {
            return deviceIdentifierArn;
        }

        public final void setDeviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
        }

        @Override
        public final Builder deviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
            return this;
        }

        public final String getIccid() {
            return iccid;
        }

        public final void setIccid(String iccid) {
            this.iccid = iccid;
        }

        @Override
        public final Builder iccid(String iccid) {
            this.iccid = iccid;
            return this;
        }

        public final String getImsi() {
            return imsi;
        }

        public final void setImsi(String imsi) {
            this.imsi = imsi;
        }

        @Override
        public final Builder imsi(String imsi) {
            this.imsi = imsi;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getOrderArn() {
            return orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceIdentifierStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrafficGroupArn() {
            return trafficGroupArn;
        }

        public final void setTrafficGroupArn(String trafficGroupArn) {
            this.trafficGroupArn = trafficGroupArn;
        }

        @Override
        public final Builder trafficGroupArn(String trafficGroupArn) {
            this.trafficGroupArn = trafficGroupArn;
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        @Override
        public DeviceIdentifier build() {
            return new DeviceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
