/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksClient;
import software.amazon.awssdk.services.privatenetworks.internal.UserAgentUtils;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse;

public class ListDeviceIdentifiersIterable
implements SdkIterable<ListDeviceIdentifiersResponse> {
    private final PrivateNetworksClient client;
    private final ListDeviceIdentifiersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceIdentifiersIterable(PrivateNetworksClient client, ListDeviceIdentifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeviceIdentifiersResponseFetcher();
    }

    public Iterator<ListDeviceIdentifiersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceIdentifier> deviceIdentifiers() {
        Function<ListDeviceIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceIdentifiers() != null) {
                return response.deviceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeviceIdentifiersResponseFetcher
    implements SyncPageFetcher<ListDeviceIdentifiersResponse> {
        private ListDeviceIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceIdentifiersResponse nextPage(ListDeviceIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceIdentifiersIterable.this.client.listDeviceIdentifiers(ListDeviceIdentifiersIterable.this.firstRequest);
            }
            return ListDeviceIdentifiersIterable.this.client.listDeviceIdentifiers((ListDeviceIdentifiersRequest)((Object)ListDeviceIdentifiersIterable.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

