/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation;

public class DescribeOptOutListsPublisher
implements SdkPublisher<DescribeOptOutListsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeOptOutListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOptOutListsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeOptOutListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOptOutListsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeOptOutListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOptOutListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOptOutListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OptOutListInformation> optOutLists() {
        Function<DescribeOptOutListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optOutLists() != null) {
                return response.optOutLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOptOutListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOptOutListsResponseFetcher
    implements AsyncPageFetcher<DescribeOptOutListsResponse> {
        private DescribeOptOutListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptOutListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOptOutListsResponse> nextPage(DescribeOptOutListsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptOutListsPublisher.this.client.describeOptOutLists(DescribeOptOutListsPublisher.this.firstRequest);
            }
            return DescribeOptOutListsPublisher.this.client.describeOptOutLists((DescribeOptOutListsRequest)((Object)DescribeOptOutListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

