/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class KeywordInformationListCopier {
    static List<KeywordInformation> copy(Collection<? extends KeywordInformation> keywordInformationListParam) {
        List<KeywordInformation> list;
        if (keywordInformationListParam == null || keywordInformationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeywordInformation> modifiableList = new ArrayList<>();
            keywordInformationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<KeywordInformation> copyFromBuilder(Collection<? extends KeywordInformation.Builder> keywordInformationListParam) {
        List<KeywordInformation> list;
        if (keywordInformationListParam == null || keywordInformationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeywordInformation> modifiableList = new ArrayList<>();
            keywordInformationListParam.forEach(entry -> {
                KeywordInformation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<KeywordInformation.Builder> copyToBuilder(Collection<? extends KeywordInformation> keywordInformationListParam) {
        List<KeywordInformation.Builder> list;
        if (keywordInformationListParam == null || keywordInformationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeywordInformation.Builder> modifiableList = new ArrayList<>();
            keywordInformationListParam.forEach(entry -> {
                KeywordInformation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
