/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOptOutListResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CreateOptOutListResponse.Builder, CreateOptOutListResponse> {
    private static final SdkField<String> OPT_OUT_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListArn").getter(getter(CreateOptOutListResponse::optOutListArn))
            .setter(setter(Builder::optOutListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListArn").build()).build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(CreateOptOutListResponse::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateOptOutListResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CreateOptOutListResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_ARN_FIELD,
            OPT_OUT_LIST_NAME_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));

    private final String optOutListArn;

    private final String optOutListName;

    private final List<Tag> tags;

    private final Instant createdTimestamp;

    private CreateOptOutListResponse(BuilderImpl builder) {
        super(builder);
        this.optOutListArn = builder.optOutListArn;
        this.optOutListName = builder.optOutListName;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the OptOutList.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the OptOutList.
     */
    public final String optOutListArn() {
        return optOutListArn;
    }

    /**
     * <p>
     * The name of the new OptOutList.
     * </p>
     * 
     * @return The name of the new OptOutList.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) associated with the new OptOutList.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) associated with the new OptOutList.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     *         format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optOutListArn());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptOutListResponse)) {
            return false;
        }
        CreateOptOutListResponse other = (CreateOptOutListResponse) obj;
        return Objects.equals(optOutListArn(), other.optOutListArn()) && Objects.equals(optOutListName(), other.optOutListName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOptOutListResponse").add("OptOutListArn", optOutListArn())
                .add("OptOutListName", optOutListName()).add("Tags", hasTags() ? tags() : null)
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListArn":
            return Optional.ofNullable(clazz.cast(optOutListArn()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOptOutListResponse, T> g) {
        return obj -> g.apply((CreateOptOutListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOptOutListResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the OptOutList.
         * </p>
         * 
         * @param optOutListArn
         *        The Amazon Resource Name (ARN) for the OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListArn(String optOutListArn);

        /**
         * <p>
         * The name of the new OptOutList.
         * </p>
         * 
         * @param optOutListName
         *        The name of the new OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * An array of tags (key and value pairs) associated with the new OptOutList.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) associated with the new OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) associated with the new OptOutList.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) associated with the new OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) associated with the new OptOutList.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String optOutListArn;

        private String optOutListName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptOutListResponse model) {
            super(model);
            optOutListArn(model.optOutListArn);
            optOutListName(model.optOutListName);
            tags(model.tags);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getOptOutListArn() {
            return optOutListArn;
        }

        public final void setOptOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
        }

        @Override
        public final Builder optOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateOptOutListResponse build() {
            return new CreateOptOutListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
