/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pinpointemail.DefaultPinpointEmailBaseClientBuilder;
import software.amazon.awssdk.services.pinpointemail.DefaultPinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClientBuilder;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailServiceClientConfiguration;
import software.amazon.awssdk.services.pinpointemail.endpoints.PinpointEmailEndpointProvider;

@SdkInternalApi
final class DefaultPinpointEmailClientBuilder
extends DefaultPinpointEmailBaseClientBuilder<PinpointEmailClientBuilder, PinpointEmailClient>
implements PinpointEmailClientBuilder {
    DefaultPinpointEmailClientBuilder() {
    }

    @Override
    public DefaultPinpointEmailClientBuilder endpointProvider(PinpointEmailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PinpointEmailClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPinpointEmailClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PinpointEmailServiceClientConfiguration serviceClientConfiguration = PinpointEmailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPinpointEmailClient(serviceClientConfiguration, clientConfiguration);
    }
}

