/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for a message template that can be used in messages that are sent through the
 * voice channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceTemplateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceTemplateRequest.Builder, VoiceTemplateRequest> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(VoiceTemplateRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(VoiceTemplateRequest::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(VoiceTemplateRequest::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(VoiceTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(VoiceTemplateRequest::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceId").getter(getter(VoiceTemplateRequest::voiceId)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            DEFAULT_SUBSTITUTIONS_FIELD, LANGUAGE_CODE_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, VOICE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String defaultSubstitutions;

    private final String languageCode;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String voiceId;

    private VoiceTemplateRequest(BuilderImpl builder) {
        this.body = builder.body;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.languageCode = builder.languageCode;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.voiceId = builder.voiceId;
    }

    /**
     * <p>
     * The text of the script to use in messages that are based on the message template, in plain text format.
     * </p>
     * 
     * @return The text of the script to use in messages that are based on the message template, in plain text format.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * A JSON object that specifies the default values to use for message variables in the message template. This object
     * is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines
     * the default value for that variable. When you create a message that's based on the template, you can override
     * these defaults with message-specific and address-specific variables and values.
     * </p>
     * 
     * @return A JSON object that specifies the default values to use for message variables in the message template.
     *         This object is a set of key-value pairs. Each key defines a message variable in the template. The
     *         corresponding value defines the default value for that variable. When you create a message that's based
     *         on the template, you can override these defaults with message-specific and address-specific variables and
     *         values.
     */
    public final String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The code for the language to use when synthesizing the text of the script in messages that are based on the
     * message template. For a list of supported languages and the code for each one, see the <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.
     * </p>
     * 
     * @return The code for the language to use when synthesizing the text of the script in messages that are based on
     *         the message template. For a list of supported languages and the code for each one, see the <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <note>
     * <p>
     * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not
     * processed and an error code is not returned. To manage tags we recommend using either <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
     * Reference for Amazon Pinpoint</i>, <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
     * </p>
     * </note>
     * <p>
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message
     * template. Each tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags
     *         is not processed and an error code is not returned. To manage tags we recommend using either <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
     *         <i>API Reference for Amazon Pinpoint</i>, <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     *         >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     *         "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     *         >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A custom description of the message template.
     * </p>
     * 
     * @return A custom description of the message template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the voice to use when delivering messages that are based on the message template. For a list of
     * supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly
     * Developer Guide</a>.
     * </p>
     * 
     * @return The name of the voice to use when delivering messages that are based on the message template. For a list
     *         of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon
     *         Polly Developer Guide</a>.
     */
    public final String voiceId() {
        return voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceTemplateRequest)) {
            return false;
        }
        VoiceTemplateRequest other = (VoiceTemplateRequest) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions())
                && Objects.equals(languageCode(), other.languageCode()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(voiceId(), other.voiceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceTemplateRequest").add("Body", body()).add("DefaultSubstitutions", defaultSubstitutions())
                .add("LanguageCode", languageCode()).add("Tags", hasTags() ? tags() : null)
                .add("TemplateDescription", templateDescription()).add("VoiceId", voiceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "VoiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceTemplateRequest, T> g) {
        return obj -> g.apply((VoiceTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceTemplateRequest> {
        /**
         * <p>
         * The text of the script to use in messages that are based on the message template, in plain text format.
         * </p>
         * 
         * @param body
         *        The text of the script to use in messages that are based on the message template, in plain text
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * A JSON object that specifies the default values to use for message variables in the message template. This
         * object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
         * value defines the default value for that variable. When you create a message that's based on the template,
         * you can override these defaults with message-specific and address-specific variables and values.
         * </p>
         * 
         * @param defaultSubstitutions
         *        A JSON object that specifies the default values to use for message variables in the message template.
         *        This object is a set of key-value pairs. Each key defines a message variable in the template. The
         *        corresponding value defines the default value for that variable. When you create a message that's
         *        based on the template, you can override these defaults with message-specific and address-specific
         *        variables and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The code for the language to use when synthesizing the text of the script in messages that are based on the
         * message template. For a list of supported languages and the code for each one, see the <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for the language to use when synthesizing the text of the script in messages that are based
         *        on the message template. For a list of supported languages and the code for each one, see the <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * <note>
         * <p>
         * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is
         * not processed and an error code is not returned. To manage tags we recommend using either <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
         * Reference for Amazon Pinpoint</i>, <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
         * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
         * </p>
         * </note>
         * <p>
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message
         * template. Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in
         *        tags is not processed and an error code is not returned. To manage tags we recommend using either <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
         *        <i>API Reference for Amazon Pinpoint</i>, <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         *        >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a
         *        href=
         *        "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         *        >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        A custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the voice to use when delivering messages that are based on the message template. For a list of
         * supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly
         * Developer Guide</a>.
         * </p>
         * 
         * @param voiceId
         *        The name of the voice to use when delivering messages that are based on the message template. For a
         *        list of supported voices, see the <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String defaultSubstitutions;

        private String languageCode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceTemplateRequest model) {
            body(model.body);
            defaultSubstitutions(model.defaultSubstitutions);
            languageCode(model.languageCode);
            tags(model.tags);
            templateDescription(model.templateDescription);
            voiceId(model.voiceId);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public VoiceTemplateRequest build() {
            return new VoiceTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
