/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies demographic-based dimension settings for including or excluding endpoints from a segment. These settings
 * derive from characteristics of endpoint devices, such as platform, make, and model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentDemographics implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentDemographics.Builder, SegmentDemographics> {
    private static final SdkField<SetDimension> APP_VERSION_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("AppVersion").getter(getter(SegmentDemographics::appVersion)).setter(setter(Builder::appVersion))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVersion").build()).build();

    private static final SdkField<SetDimension> CHANNEL_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Channel").getter(getter(SegmentDemographics::channel)).setter(setter(Builder::channel))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<SetDimension> DEVICE_TYPE_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceType").getter(getter(SegmentDemographics::deviceType)).setter(setter(Builder::deviceType))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<SetDimension> MAKE_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Make").getter(getter(SegmentDemographics::make)).setter(setter(Builder::make))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Make").build()).build();

    private static final SdkField<SetDimension> MODEL_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Model").getter(getter(SegmentDemographics::model)).setter(setter(Builder::model))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<SetDimension> PLATFORM_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Platform").getter(getter(SegmentDemographics::platform)).setter(setter(Builder::platform))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSION_FIELD,
            CHANNEL_FIELD, DEVICE_TYPE_FIELD, MAKE_FIELD, MODEL_FIELD, PLATFORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final SetDimension appVersion;

    private final SetDimension channel;

    private final SetDimension deviceType;

    private final SetDimension make;

    private final SetDimension model;

    private final SetDimension platform;

    private SegmentDemographics(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.channel = builder.channel;
        this.deviceType = builder.deviceType;
        this.make = builder.make;
        this.model = builder.model;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The app version criteria for the segment.
     * </p>
     * 
     * @return The app version criteria for the segment.
     */
    public final SetDimension appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The channel criteria for the segment.
     * </p>
     * 
     * @return The channel criteria for the segment.
     */
    public final SetDimension channel() {
        return channel;
    }

    /**
     * <p>
     * The device type criteria for the segment.
     * </p>
     * 
     * @return The device type criteria for the segment.
     */
    public final SetDimension deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * The device make criteria for the segment.
     * </p>
     * 
     * @return The device make criteria for the segment.
     */
    public final SetDimension make() {
        return make;
    }

    /**
     * <p>
     * The device model criteria for the segment.
     * </p>
     * 
     * @return The device model criteria for the segment.
     */
    public final SetDimension model() {
        return model;
    }

    /**
     * <p>
     * The device platform criteria for the segment.
     * </p>
     * 
     * @return The device platform criteria for the segment.
     */
    public final SetDimension platform() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(make());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDemographics)) {
            return false;
        }
        SegmentDemographics other = (SegmentDemographics) obj;
        return Objects.equals(appVersion(), other.appVersion()) && Objects.equals(channel(), other.channel())
                && Objects.equals(deviceType(), other.deviceType()) && Objects.equals(make(), other.make())
                && Objects.equals(model(), other.model()) && Objects.equals(platform(), other.platform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentDemographics").add("AppVersion", appVersion()).add("Channel", channel())
                .add("DeviceType", deviceType()).add("Make", make()).add("Model", model()).add("Platform", platform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "Make":
            return Optional.ofNullable(clazz.cast(make()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDemographics, T> g) {
        return obj -> g.apply((SegmentDemographics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentDemographics> {
        /**
         * <p>
         * The app version criteria for the segment.
         * </p>
         * 
         * @param appVersion
         *        The app version criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(SetDimension appVersion);

        /**
         * <p>
         * The app version criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #appVersion(SetDimension)}.
         * 
         * @param appVersion
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appVersion(SetDimension)
         */
        default Builder appVersion(Consumer<SetDimension.Builder> appVersion) {
            return appVersion(SetDimension.builder().applyMutation(appVersion).build());
        }

        /**
         * <p>
         * The channel criteria for the segment.
         * </p>
         * 
         * @param channel
         *        The channel criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(SetDimension channel);

        /**
         * <p>
         * The channel criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #channel(SetDimension)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(SetDimension)
         */
        default Builder channel(Consumer<SetDimension.Builder> channel) {
            return channel(SetDimension.builder().applyMutation(channel).build());
        }

        /**
         * <p>
         * The device type criteria for the segment.
         * </p>
         * 
         * @param deviceType
         *        The device type criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(SetDimension deviceType);

        /**
         * <p>
         * The device type criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceType(SetDimension)}.
         * 
         * @param deviceType
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceType(SetDimension)
         */
        default Builder deviceType(Consumer<SetDimension.Builder> deviceType) {
            return deviceType(SetDimension.builder().applyMutation(deviceType).build());
        }

        /**
         * <p>
         * The device make criteria for the segment.
         * </p>
         * 
         * @param make
         *        The device make criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder make(SetDimension make);

        /**
         * <p>
         * The device make criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #make(SetDimension)}.
         * 
         * @param make
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #make(SetDimension)
         */
        default Builder make(Consumer<SetDimension.Builder> make) {
            return make(SetDimension.builder().applyMutation(make).build());
        }

        /**
         * <p>
         * The device model criteria for the segment.
         * </p>
         * 
         * @param model
         *        The device model criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(SetDimension model);

        /**
         * <p>
         * The device model criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #model(SetDimension)}.
         * 
         * @param model
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #model(SetDimension)
         */
        default Builder model(Consumer<SetDimension.Builder> model) {
            return model(SetDimension.builder().applyMutation(model).build());
        }

        /**
         * <p>
         * The device platform criteria for the segment.
         * </p>
         * 
         * @param platform
         *        The device platform criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(SetDimension platform);

        /**
         * <p>
         * The device platform criteria for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #platform(SetDimension)}.
         * 
         * @param platform
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platform(SetDimension)
         */
        default Builder platform(Consumer<SetDimension.Builder> platform) {
            return platform(SetDimension.builder().applyMutation(platform).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SetDimension appVersion;

        private SetDimension channel;

        private SetDimension deviceType;

        private SetDimension make;

        private SetDimension model;

        private SetDimension platform;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDemographics model) {
            appVersion(model.appVersion);
            channel(model.channel);
            deviceType(model.deviceType);
            make(model.make);
            model(model.model);
            platform(model.platform);
        }

        public final SetDimension.Builder getAppVersion() {
            return appVersion != null ? appVersion.toBuilder() : null;
        }

        public final void setAppVersion(SetDimension.BuilderImpl appVersion) {
            this.appVersion = appVersion != null ? appVersion.build() : null;
        }

        @Override
        public final Builder appVersion(SetDimension appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final SetDimension.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        public final void setChannel(SetDimension.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(SetDimension channel) {
            this.channel = channel;
            return this;
        }

        public final SetDimension.Builder getDeviceType() {
            return deviceType != null ? deviceType.toBuilder() : null;
        }

        public final void setDeviceType(SetDimension.BuilderImpl deviceType) {
            this.deviceType = deviceType != null ? deviceType.build() : null;
        }

        @Override
        public final Builder deviceType(SetDimension deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final SetDimension.Builder getMake() {
            return make != null ? make.toBuilder() : null;
        }

        public final void setMake(SetDimension.BuilderImpl make) {
            this.make = make != null ? make.build() : null;
        }

        @Override
        public final Builder make(SetDimension make) {
            this.make = make;
            return this;
        }

        public final SetDimension.Builder getModel() {
            return model != null ? model.toBuilder() : null;
        }

        public final void setModel(SetDimension.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(SetDimension model) {
            this.model = model;
            return this;
        }

        public final SetDimension.Builder getPlatform() {
            return platform != null ? platform.toBuilder() : null;
        }

        public final void setPlatform(SetDimension.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        @Override
        public final Builder platform(SetDimension platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public SegmentDemographics build() {
            return new SegmentDemographics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
