/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the schedule settings for a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneySchedule implements SdkPojo, Serializable, ToCopyableBuilder<JourneySchedule.Builder, JourneySchedule> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(JourneySchedule::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(JourneySchedule::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(JourneySchedule::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            START_TIME_FIELD, TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final Instant startTime;

    private final String timezone;

    private JourneySchedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The scheduled time, in ISO 8601 format, when the journey ended or will end.
     * </p>
     * 
     * @return The scheduled time, in ISO 8601 format, when the journey ended or will end.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The scheduled time, in ISO 8601 format, when the journey began or will begin.
     * </p>
     * 
     * @return The scheduled time, in ISO 8601 format, when the journey began or will begin.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true. Valid
     * values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06,
     * UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13,
     * UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-09:30,
     * UTC-10, and UTC-11.
     * </p>
     * 
     * @return The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is
     *         true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
     *         UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11,
     *         UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06,
     *         UTC-07, UTC-08, UTC-09, UTC-09:30, UTC-10, and UTC-11.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneySchedule)) {
            return false;
        }
        JourneySchedule other = (JourneySchedule) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneySchedule").add("EndTime", endTime()).add("StartTime", startTime())
                .add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneySchedule, T> g) {
        return obj -> g.apply((JourneySchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneySchedule> {
        /**
         * <p>
         * The scheduled time, in ISO 8601 format, when the journey ended or will end.
         * </p>
         * 
         * @param endTime
         *        The scheduled time, in ISO 8601 format, when the journey ended or will end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The scheduled time, in ISO 8601 format, when the journey began or will begin.
         * </p>
         * 
         * @param startTime
         *        The scheduled time, in ISO 8601 format, when the journey began or will begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true.
         * Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45,
         * UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12,
         * UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08,
         * UTC-09, UTC-09:30, UTC-10, and UTC-11.
         * </p>
         * 
         * @param timezone
         *        The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is
         *        true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
         *        UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11,
         *        UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06,
         *        UTC-07, UTC-08, UTC-09, UTC-09:30, UTC-10, and UTC-11.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private Instant startTime;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneySchedule model) {
            endTime(model.endTime);
            startTime(model.startTime);
            timezone(model.timezone);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public JourneySchedule build() {
            return new JourneySchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
