/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of recommendations for the insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(Recommendation::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> RECOMMENDATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationDescription").getter(getter(Recommendation::recommendationDescription))
            .setter(setter(Builder::recommendationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            RECOMMENDATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String recommendationDescription;

    private Recommendation(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.recommendationDescription = builder.recommendationDescription;
    }

    /**
     * <p>
     * The unique identifier for the recommendation.
     * </p>
     * 
     * @return The unique identifier for the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The recommendation details to help resolve the performance issue. For example,
     * <code>Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id</code>
     * </p>
     * 
     * @return The recommendation details to help resolve the performance issue. For example,
     *         <code>Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id</code>
     */
    public final String recommendationDescription() {
        return recommendationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(recommendationDescription(), other.recommendationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("RecommendationId", recommendationId())
                .add("RecommendationDescription", recommendationDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "RecommendationDescription":
            return Optional.ofNullable(clazz.cast(recommendationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * The unique identifier for the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The unique identifier for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The recommendation details to help resolve the performance issue. For example,
         * <code>Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id</code>
         * </p>
         * 
         * @param recommendationDescription
         *        The recommendation details to help resolve the performance issue. For example,
         *        <code>Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationDescription(String recommendationDescription);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String recommendationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            recommendationId(model.recommendationId);
            recommendationDescription(model.recommendationDescription);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRecommendationDescription() {
            return recommendationDescription;
        }

        public final void setRecommendationDescription(String recommendationDescription) {
            this.recommendationDescription = recommendationDescription;
        }

        @Override
        public final Builder recommendationDescription(String recommendationDescription) {
            this.recommendationDescription = recommendationDescription;
            return this;
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
