/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves the summary of the performance analysis report created for a time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisReport implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisReport.Builder, AnalysisReport> {
    private static final SdkField<String> ANALYSIS_REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisReportId").getter(getter(AnalysisReport::analysisReportId))
            .setter(setter(Builder::analysisReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportId").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(AnalysisReport::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(AnalysisReport::serviceTypeAsString)).setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(AnalysisReport::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AnalysisReport::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AnalysisReport::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AnalysisReport::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<Insight>> INSIGHTS_FIELD = SdkField
            .<List<Insight>> builder(MarshallingType.LIST)
            .memberName("Insights")
            .getter(getter(AnalysisReport::insights))
            .setter(setter(Builder::insights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Insight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Insight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORT_ID_FIELD,
            IDENTIFIER_FIELD, SERVICE_TYPE_FIELD, CREATE_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD,
            INSIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analysisReportId;

    private final String identifier;

    private final String serviceType;

    private final Instant createTime;

    private final Instant startTime;

    private final Instant endTime;

    private final String status;

    private final List<Insight> insights;

    private AnalysisReport(BuilderImpl builder) {
        this.analysisReportId = builder.analysisReportId;
        this.identifier = builder.identifier;
        this.serviceType = builder.serviceType;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.insights = builder.insights;
    }

    /**
     * <p>
     * The name of the analysis report.
     * </p>
     * 
     * @return The name of the analysis report.
     */
    public final String analysisReportId() {
        return analysisReportId;
    }

    /**
     * <p>
     * The unique identifier of the analysis report.
     * </p>
     * 
     * @return The unique identifier of the analysis report.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid
     *         values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid
     *         values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * The time you created the analysis report.
     * </p>
     * 
     * @return The time you created the analysis report.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The analysis start time in the report.
     * </p>
     * 
     * @return The analysis start time in the report.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The analysis end time in the report.
     * </p>
     * 
     * @return The analysis end time in the report.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the created analysis report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the created analysis report.
     * @see AnalysisStatus
     */
    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the created analysis report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the created analysis report.
     * @see AnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Insights property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInsights() {
        return insights != null && !(insights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of identified insights in the analysis report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsights} method.
     * </p>
     * 
     * @return The list of identified insights in the analysis report.
     */
    public final List<Insight> insights() {
        return insights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisReportId());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsights() ? insights() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisReport)) {
            return false;
        }
        AnalysisReport other = (AnalysisReport) obj;
        return Objects.equals(analysisReportId(), other.analysisReportId()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasInsights() == other.hasInsights() && Objects.equals(insights(), other.insights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisReport").add("AnalysisReportId", analysisReportId()).add("Identifier", identifier())
                .add("ServiceType", serviceTypeAsString()).add("CreateTime", createTime()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Status", statusAsString()).add("Insights", hasInsights() ? insights() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisReportId":
            return Optional.ofNullable(clazz.cast(analysisReportId()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Insights":
            return Optional.ofNullable(clazz.cast(insights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisReport, T> g) {
        return obj -> g.apply((AnalysisReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisReport> {
        /**
         * <p>
         * The name of the analysis report.
         * </p>
         * 
         * @param analysisReportId
         *        The name of the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReportId(String analysisReportId);

        /**
         * <p>
         * The unique identifier of the analysis report.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid
         * values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        List the tags for the Amazon Web Services service for which Performance Insights returns metrics.
         *        Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid
         * values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        List the tags for the Amazon Web Services service for which Performance Insights returns metrics.
         *        Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * The time you created the analysis report.
         * </p>
         * 
         * @param createTime
         *        The time you created the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The analysis start time in the report.
         * </p>
         * 
         * @param startTime
         *        The analysis start time in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The analysis end time in the report.
         * </p>
         * 
         * @param endTime
         *        The analysis end time in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of the created analysis report.
         * </p>
         * 
         * @param status
         *        The status of the created analysis report.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the created analysis report.
         * </p>
         * 
         * @param status
         *        The status of the created analysis report.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(AnalysisStatus status);

        /**
         * <p>
         * The list of identified insights in the analysis report.
         * </p>
         * 
         * @param insights
         *        The list of identified insights in the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(Collection<Insight> insights);

        /**
         * <p>
         * The list of identified insights in the analysis report.
         * </p>
         * 
         * @param insights
         *        The list of identified insights in the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(Insight... insights);

        /**
         * <p>
         * The list of identified insights in the analysis report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pi.model.Insight.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pi.model.Insight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.pi.model.Insight.Builder#build()}
         * is called immediately and its result is passed to {@link #insights(List<Insight>)}.
         * 
         * @param insights
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.pi.model.Insight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insights(java.util.Collection<Insight>)
         */
        Builder insights(Consumer<Insight.Builder>... insights);
    }

    static final class BuilderImpl implements Builder {
        private String analysisReportId;

        private String identifier;

        private String serviceType;

        private Instant createTime;

        private Instant startTime;

        private Instant endTime;

        private String status;

        private List<Insight> insights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisReport model) {
            analysisReportId(model.analysisReportId);
            identifier(model.identifier);
            serviceType(model.serviceType);
            createTime(model.createTime);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            insights(model.insights);
        }

        public final String getAnalysisReportId() {
            return analysisReportId;
        }

        public final void setAnalysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
        }

        @Override
        public final Builder analysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Insight.Builder> getInsights() {
            List<Insight.Builder> result = InsightListCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<Insight.BuilderImpl> insights) {
            this.insights = InsightListCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<Insight> insights) {
            this.insights = InsightListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Insight... insights) {
            insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<Insight.Builder>... insights) {
            insights(Stream.of(insights).map(c -> Insight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalysisReport build() {
            return new AnalysisReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
