/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pi.model.AcceptLanguage;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.services.pi.model.TextFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPerformanceAnalysisReportRequest
extends PiRequest
implements ToCopyableBuilder<Builder, GetPerformanceAnalysisReportRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(GetPerformanceAnalysisReportRequest.getter(GetPerformanceAnalysisReportRequest::serviceTypeAsString)).setter(GetPerformanceAnalysisReportRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetPerformanceAnalysisReportRequest.getter(GetPerformanceAnalysisReportRequest::identifier)).setter(GetPerformanceAnalysisReportRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> ANALYSIS_REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisReportId").getter(GetPerformanceAnalysisReportRequest.getter(GetPerformanceAnalysisReportRequest::analysisReportId)).setter(GetPerformanceAnalysisReportRequest.setter(Builder::analysisReportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportId").build()}).build();
    private static final SdkField<String> TEXT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextFormat").getter(GetPerformanceAnalysisReportRequest.getter(GetPerformanceAnalysisReportRequest::textFormatAsString)).setter(GetPerformanceAnalysisReportRequest.setter(Builder::textFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextFormat").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(GetPerformanceAnalysisReportRequest.getter(GetPerformanceAnalysisReportRequest::acceptLanguageAsString)).setter(GetPerformanceAnalysisReportRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, ANALYSIS_REPORT_ID_FIELD, TEXT_FORMAT_FIELD, ACCEPT_LANGUAGE_FIELD));
    private final String serviceType;
    private final String identifier;
    private final String analysisReportId;
    private final String textFormat;
    private final String acceptLanguage;

    private GetPerformanceAnalysisReportRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.analysisReportId = builder.analysisReportId;
        this.textFormat = builder.textFormat;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String analysisReportId() {
        return this.analysisReportId;
    }

    public final TextFormat textFormat() {
        return TextFormat.fromValue(this.textFormat);
    }

    public final String textFormatAsString() {
        return this.textFormat;
    }

    public final AcceptLanguage acceptLanguage() {
        return AcceptLanguage.fromValue(this.acceptLanguage);
    }

    public final String acceptLanguageAsString() {
        return this.acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisReportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.textFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPerformanceAnalysisReportRequest)) {
            return false;
        }
        GetPerformanceAnalysisReportRequest other = (GetPerformanceAnalysisReportRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.analysisReportId(), other.analysisReportId()) && Objects.equals(this.textFormatAsString(), other.textFormatAsString()) && Objects.equals(this.acceptLanguageAsString(), other.acceptLanguageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetPerformanceAnalysisReportRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("AnalysisReportId", (Object)this.analysisReportId()).add("TextFormat", (Object)this.textFormatAsString()).add("AcceptLanguage", (Object)this.acceptLanguageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "AnalysisReportId": {
                return Optional.ofNullable(clazz.cast(this.analysisReportId()));
            }
            case "TextFormat": {
                return Optional.ofNullable(clazz.cast(this.textFormatAsString()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPerformanceAnalysisReportRequest, T> g) {
        return obj -> g.apply((GetPerformanceAnalysisReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private String analysisReportId;
        private String textFormat;
        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPerformanceAnalysisReportRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.analysisReportId(model.analysisReportId);
            this.textFormat(model.textFormat);
            this.acceptLanguage(model.acceptLanguage);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getAnalysisReportId() {
            return this.analysisReportId;
        }

        public final void setAnalysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
        }

        @Override
        public final Builder analysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
            return this;
        }

        public final String getTextFormat() {
            return this.textFormat;
        }

        public final void setTextFormat(String textFormat) {
            this.textFormat = textFormat;
        }

        @Override
        public final Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        @Override
        public final Builder textFormat(TextFormat textFormat) {
            this.textFormat(textFormat == null ? null : textFormat.toString());
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public final Builder acceptLanguage(AcceptLanguage acceptLanguage) {
            this.acceptLanguage(acceptLanguage == null ? null : acceptLanguage.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPerformanceAnalysisReportRequest build() {
            return new GetPerformanceAnalysisReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPerformanceAnalysisReportRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder analysisReportId(String var1);

        public Builder textFormat(String var1);

        public Builder textFormat(TextFormat var1);

        public Builder acceptLanguage(String var1);

        public Builder acceptLanguage(AcceptLanguage var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

