/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPerformanceAnalysisReportRequest extends PiRequest implements
        ToCopyableBuilder<GetPerformanceAnalysisReportRequest.Builder, GetPerformanceAnalysisReportRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(GetPerformanceAnalysisReportRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetPerformanceAnalysisReportRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> ANALYSIS_REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisReportId").getter(getter(GetPerformanceAnalysisReportRequest::analysisReportId))
            .setter(setter(Builder::analysisReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportId").build()).build();

    private static final SdkField<String> TEXT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextFormat").getter(getter(GetPerformanceAnalysisReportRequest::textFormatAsString))
            .setter(setter(Builder::textFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextFormat").build()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(GetPerformanceAnalysisReportRequest::acceptLanguageAsString))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, ANALYSIS_REPORT_ID_FIELD, TEXT_FORMAT_FIELD, ACCEPT_LANGUAGE_FIELD));

    private final String serviceType;

    private final String identifier;

    private final String analysisReportId;

    private final String textFormat;

    private final String acceptLanguage;

    private GetPerformanceAnalysisReportRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.analysisReportId = builder.analysisReportId;
        this.textFormat = builder.textFormat;
        this.acceptLanguage = builder.acceptLanguage;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
     * <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
     *         <code>RDS</code>.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
     * <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
     *         <code>RDS</code>.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights
     * gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>. When you
     * call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
     * </p>
     * <p>
     * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
     *         Insights gathers metrics from this data source. In the console, the identifier is shown as
     *         <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
     *         <code>DbiResourceId</code>.</p>
     *         <p>
     *         To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     *         <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A unique identifier of the created analysis report. For example, <code>report-12345678901234567</code>
     * </p>
     * 
     * @return A unique identifier of the created analysis report. For example, <code>report-12345678901234567</code>
     */
    public final String analysisReportId() {
        return analysisReportId;
    }

    /**
     * <p>
     * Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>. The
     * default value is <code>plain text</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textFormat} will
     * return {@link TextFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textFormatAsString}.
     * </p>
     * 
     * @return Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>
     *         . The default value is <code>plain text</code>.
     * @see TextFormat
     */
    public final TextFormat textFormat() {
        return TextFormat.fromValue(textFormat);
    }

    /**
     * <p>
     * Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>. The
     * default value is <code>plain text</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textFormat} will
     * return {@link TextFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textFormatAsString}.
     * </p>
     * 
     * @return Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>
     *         . The default value is <code>plain text</code>.
     * @see TextFormat
     */
    public final String textFormatAsString() {
        return textFormat;
    }

    /**
     * <p>
     * The text language in the report. The default language is <code>EN_US</code> (English).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptLanguage}
     * will return {@link AcceptLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptLanguageAsString}.
     * </p>
     * 
     * @return The text language in the report. The default language is <code>EN_US</code> (English).
     * @see AcceptLanguage
     */
    public final AcceptLanguage acceptLanguage() {
        return AcceptLanguage.fromValue(acceptLanguage);
    }

    /**
     * <p>
     * The text language in the report. The default language is <code>EN_US</code> (English).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptLanguage}
     * will return {@link AcceptLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptLanguageAsString}.
     * </p>
     * 
     * @return The text language in the report. The default language is <code>EN_US</code> (English).
     * @see AcceptLanguage
     */
    public final String acceptLanguageAsString() {
        return acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(analysisReportId());
        hashCode = 31 * hashCode + Objects.hashCode(textFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPerformanceAnalysisReportRequest)) {
            return false;
        }
        GetPerformanceAnalysisReportRequest other = (GetPerformanceAnalysisReportRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(analysisReportId(), other.analysisReportId())
                && Objects.equals(textFormatAsString(), other.textFormatAsString())
                && Objects.equals(acceptLanguageAsString(), other.acceptLanguageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPerformanceAnalysisReportRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("AnalysisReportId", analysisReportId())
                .add("TextFormat", textFormatAsString()).add("AcceptLanguage", acceptLanguageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "AnalysisReportId":
            return Optional.ofNullable(clazz.cast(analysisReportId()));
        case "TextFormat":
            return Optional.ofNullable(clazz.cast(textFormatAsString()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPerformanceAnalysisReportRequest, T> g) {
        return obj -> g.apply((GetPerformanceAnalysisReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPerformanceAnalysisReportRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
         * <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
         *        <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
         * <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights will return metrics. Valid value is
         *        <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>.
         * When you call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
         * </p>
         * <p>
         * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
         * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique for an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. In the console, the identifier is shown as
         *        <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
         *        <code>DbiResourceId</code>.</p>
         *        <p>
         *        To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example,
         *        specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A unique identifier of the created analysis report. For example, <code>report-12345678901234567</code>
         * </p>
         * 
         * @param analysisReportId
         *        A unique identifier of the created analysis report. For example, <code>report-12345678901234567</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReportId(String analysisReportId);

        /**
         * <p>
         * Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>.
         * The default value is <code>plain text</code>.
         * </p>
         * 
         * @param textFormat
         *        Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or
         *        <code>MARKDOWN</code>. The default value is <code>plain text</code>.
         * @see TextFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextFormat
         */
        Builder textFormat(String textFormat);

        /**
         * <p>
         * Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or <code>MARKDOWN</code>.
         * The default value is <code>plain text</code>.
         * </p>
         * 
         * @param textFormat
         *        Indicates the text format in the report. The options are <code>PLAIN_TEXT</code> or
         *        <code>MARKDOWN</code>. The default value is <code>plain text</code>.
         * @see TextFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextFormat
         */
        Builder textFormat(TextFormat textFormat);

        /**
         * <p>
         * The text language in the report. The default language is <code>EN_US</code> (English).
         * </p>
         * 
         * @param acceptLanguage
         *        The text language in the report. The default language is <code>EN_US</code> (English).
         * @see AcceptLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptLanguage
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The text language in the report. The default language is <code>EN_US</code> (English).
         * </p>
         * 
         * @param acceptLanguage
         *        The text language in the report. The default language is <code>EN_US</code> (English).
         * @see AcceptLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptLanguage
         */
        Builder acceptLanguage(AcceptLanguage acceptLanguage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private String analysisReportId;

        private String textFormat;

        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPerformanceAnalysisReportRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            analysisReportId(model.analysisReportId);
            textFormat(model.textFormat);
            acceptLanguage(model.acceptLanguage);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getAnalysisReportId() {
            return analysisReportId;
        }

        public final void setAnalysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
        }

        @Override
        public final Builder analysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
            return this;
        }

        public final String getTextFormat() {
            return textFormat;
        }

        public final void setTextFormat(String textFormat) {
            this.textFormat = textFormat;
        }

        @Override
        public final Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        @Override
        public final Builder textFormat(TextFormat textFormat) {
            this.textFormat(textFormat == null ? null : textFormat.toString());
            return this;
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public final Builder acceptLanguage(AcceptLanguage acceptLanguage) {
            this.acceptLanguage(acceptLanguage == null ? null : acceptLanguage.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPerformanceAnalysisReportRequest build() {
            return new GetPerformanceAnalysisReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
