/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersonalizedRankingResponse extends PersonalizeRuntimeResponse implements
        ToCopyableBuilder<GetPersonalizedRankingResponse.Builder, GetPersonalizedRankingResponse> {
    private static final SdkField<List<PredictedItem>> PERSONALIZED_RANKING_FIELD = SdkField
            .<List<PredictedItem>> builder(MarshallingType.LIST)
            .memberName("personalizedRanking")
            .getter(getter(GetPersonalizedRankingResponse::personalizedRanking))
            .setter(setter(Builder::personalizedRanking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizedRanking").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictedItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictedItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(GetPersonalizedRankingResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONALIZED_RANKING_FIELD,
            RECOMMENDATION_ID_FIELD));

    private final List<PredictedItem> personalizedRanking;

    private final String recommendationId;

    private GetPersonalizedRankingResponse(BuilderImpl builder) {
        super(builder);
        this.personalizedRanking = builder.personalizedRanking;
        this.recommendationId = builder.recommendationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PersonalizedRanking property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPersonalizedRanking() {
        return personalizedRanking != null && !(personalizedRanking instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items in order of most likely interest to the user. The maximum is 500.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonalizedRanking} method.
     * </p>
     * 
     * @return A list of items in order of most likely interest to the user. The maximum is 500.
     */
    public final List<PredictedItem> personalizedRanking() {
        return personalizedRanking;
    }

    /**
     * <p>
     * The ID of the recommendation.
     * </p>
     * 
     * @return The ID of the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPersonalizedRanking() ? personalizedRanking() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalizedRankingResponse)) {
            return false;
        }
        GetPersonalizedRankingResponse other = (GetPersonalizedRankingResponse) obj;
        return hasPersonalizedRanking() == other.hasPersonalizedRanking()
                && Objects.equals(personalizedRanking(), other.personalizedRanking())
                && Objects.equals(recommendationId(), other.recommendationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPersonalizedRankingResponse")
                .add("PersonalizedRanking", hasPersonalizedRanking() ? personalizedRanking() : null)
                .add("RecommendationId", recommendationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "personalizedRanking":
            return Optional.ofNullable(clazz.cast(personalizedRanking()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalizedRankingResponse, T> g) {
        return obj -> g.apply((GetPersonalizedRankingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPersonalizedRankingResponse> {
        /**
         * <p>
         * A list of items in order of most likely interest to the user. The maximum is 500.
         * </p>
         * 
         * @param personalizedRanking
         *        A list of items in order of most likely interest to the user. The maximum is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizedRanking(Collection<PredictedItem> personalizedRanking);

        /**
         * <p>
         * A list of items in order of most likely interest to the user. The maximum is 500.
         * </p>
         * 
         * @param personalizedRanking
         *        A list of items in order of most likely interest to the user. The maximum is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizedRanking(PredictedItem... personalizedRanking);

        /**
         * <p>
         * A list of items in order of most likely interest to the user. The maximum is 500.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder#build()} is called
         * immediately and its result is passed to {@link #personalizedRanking(List<PredictedItem>)}.
         * 
         * @param personalizedRanking
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalizedRanking(java.util.Collection<PredictedItem>)
         */
        Builder personalizedRanking(Consumer<PredictedItem.Builder>... personalizedRanking);

        /**
         * <p>
         * The ID of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);
    }

    static final class BuilderImpl extends PersonalizeRuntimeResponse.BuilderImpl implements Builder {
        private List<PredictedItem> personalizedRanking = DefaultSdkAutoConstructList.getInstance();

        private String recommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalizedRankingResponse model) {
            super(model);
            personalizedRanking(model.personalizedRanking);
            recommendationId(model.recommendationId);
        }

        public final List<PredictedItem.Builder> getPersonalizedRanking() {
            List<PredictedItem.Builder> result = ItemListCopier.copyToBuilder(this.personalizedRanking);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersonalizedRanking(Collection<PredictedItem.BuilderImpl> personalizedRanking) {
            this.personalizedRanking = ItemListCopier.copyFromBuilder(personalizedRanking);
        }

        @Override
        public final Builder personalizedRanking(Collection<PredictedItem> personalizedRanking) {
            this.personalizedRanking = ItemListCopier.copy(personalizedRanking);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalizedRanking(PredictedItem... personalizedRanking) {
            personalizedRanking(Arrays.asList(personalizedRanking));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalizedRanking(Consumer<PredictedItem.Builder>... personalizedRanking) {
            personalizedRanking(Stream.of(personalizedRanking).map(c -> PredictedItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        @Override
        public GetPersonalizedRankingResponse build() {
            return new GetPersonalizedRankingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
