/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IngestionMode {
    BULK("BULK"),
    PUT("PUT"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IngestionMode> VALUE_MAP;
    private final String value;

    private IngestionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IngestionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IngestionMode> knownValues() {
        EnumSet<IngestionMode> knownValues = EnumSet.allOf(IngestionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IngestionMode.class, IngestionMode::toString);
    }
}

