/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolutionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateSolutionRequest.Builder, CreateSolutionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSolutionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("performHPO").getter(getter(CreateSolutionRequest::performHPO)).setter(setter(Builder::performHPO))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("performAutoML").getter(getter(CreateSolutionRequest::performAutoML))
            .setter(setter(Builder::performAutoML))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeArn").getter(getter(CreateSolutionRequest::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(CreateSolutionRequest::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(CreateSolutionRequest::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField
            .<SolutionConfig> builder(MarshallingType.SDK_POJO).memberName("solutionConfig")
            .getter(getter(CreateSolutionRequest::solutionConfig)).setter(setter(Builder::solutionConfig))
            .constructor(SolutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateSolutionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, RECIPE_ARN_FIELD, DATASET_GROUP_ARN_FIELD,
                    EVENT_TYPE_FIELD, SOLUTION_CONFIG_FIELD, TAGS_FIELD));

    private final String name;

    private final Boolean performHPO;

    private final Boolean performAutoML;

    private final String recipeArn;

    private final String datasetGroupArn;

    private final String eventType;

    private final SolutionConfig solutionConfig;

    private final List<Tag> tags;

    private CreateSolutionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.recipeArn = builder.recipeArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.eventType = builder.eventType;
        this.solutionConfig = builder.solutionConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the solution.
     * </p>
     * 
     * @return The name for the solution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is
     * <code>false</code>.
     * </p>
     * <p>
     * When performing AutoML, this parameter is always <code>true</code> and you should not set it to
     * <code>false</code>.
     * </p>
     * 
     * @return Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is
     *         <code>false</code>.</p>
     *         <p>
     *         When performing AutoML, this parameter is always <code>true</code> and you should not set it to
     *         <code>false</code>.
     */
    public final Boolean performHPO() {
        return performHPO;
    }

    /**
     * <important>
     * <p>
     * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon
     * Personalize recipes. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
     * </p>
     * </important>
     * <p>
     * Whether to perform automated machine learning (AutoML). The default is <code>false</code>. For this case, you
     * must specify <code>recipeArn</code>.
     * </p>
     * <p>
     * When set to <code>true</code>, Amazon Personalize analyzes your training data and selects the optimal
     * USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit <code>recipeArn</code>. Amazon
     * Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML
     * lengthens the training process as compared to selecting a specific recipe.
     * </p>
     * 
     * @return <p>
     *         We don't recommend enabling automated machine learning. Instead, match your use case to the available
     *         Amazon Personalize recipes. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use
     *         case.</a>
     *         </p>
     *         </important>
     *         <p>
     *         Whether to perform automated machine learning (AutoML). The default is <code>false</code>. For this case,
     *         you must specify <code>recipeArn</code>.
     *         </p>
     *         <p>
     *         When set to <code>true</code>, Amazon Personalize analyzes your training data and selects the optimal
     *         USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit <code>recipeArn</code>.
     *         Amazon Personalize determines the optimal recipe by running tests with different values for the
     *         hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
     */
    public final Boolean performAutoML() {
        return performAutoML;
    }

    /**
     * <p>
     * The ARN of the recipe to use for model training. This is required when <code>performAutoML</code> is false.
     * </p>
     * 
     * @return The ARN of the recipe to use for model training. This is required when <code>performAutoML</code> is
     *         false.
     */
    public final String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * When your have multiple event types (using an <code>EVENT_TYPE</code> schema field), this parameter specifies
     * which event type (for example, 'click' or 'like') is used for training the model.
     * </p>
     * <p>
     * If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
     * equal weight regardless of type.
     * </p>
     * 
     * @return When your have multiple event types (using an <code>EVENT_TYPE</code> schema field), this parameter
     *         specifies which event type (for example, 'click' or 'like') is used for training the model.</p>
     *         <p>
     *         If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for
     *         training with equal weight regardless of type.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The configuration to use with the solution. When <code>performAutoML</code> is set to true, Amazon Personalize
     * only evaluates the <code>autoMLConfig</code> section of the solution configuration.
     * </p>
     * <note>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
     * </p>
     * </note>
     * 
     * @return The configuration to use with the solution. When <code>performAutoML</code> is set to true, Amazon
     *         Personalize only evaluates the <code>autoMLConfig</code> section of the solution configuration.</p>
     *         <note>
     *         <p>
     *         Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
     *         </p>
     */
    public final SolutionConfig solutionConfig() {
        return solutionConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the solution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the solution.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolutionRequest)) {
            return false;
        }
        CreateSolutionRequest other = (CreateSolutionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(performHPO(), other.performHPO())
                && Objects.equals(performAutoML(), other.performAutoML()) && Objects.equals(recipeArn(), other.recipeArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(solutionConfig(), other.solutionConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSolutionRequest").add("Name", name()).add("PerformHPO", performHPO())
                .add("PerformAutoML", performAutoML()).add("RecipeArn", recipeArn()).add("DatasetGroupArn", datasetGroupArn())
                .add("EventType", eventType()).add("SolutionConfig", solutionConfig()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "performHPO":
            return Optional.ofNullable(clazz.cast(performHPO()));
        case "performAutoML":
            return Optional.ofNullable(clazz.cast(performAutoML()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "solutionConfig":
            return Optional.ofNullable(clazz.cast(solutionConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolutionRequest, T> g) {
        return obj -> g.apply((CreateSolutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolutionRequest> {
        /**
         * <p>
         * The name for the solution.
         * </p>
         * 
         * @param name
         *        The name for the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is
         * <code>false</code>.
         * </p>
         * <p>
         * When performing AutoML, this parameter is always <code>true</code> and you should not set it to
         * <code>false</code>.
         * </p>
         * 
         * @param performHPO
         *        Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default
         *        is <code>false</code>.</p>
         *        <p>
         *        When performing AutoML, this parameter is always <code>true</code> and you should not set it to
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performHPO(Boolean performHPO);

        /**
         * <important>
         * <p>
         * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon
         * Personalize recipes. For more information, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use
         * case.</a>
         * </p>
         * </important>
         * <p>
         * Whether to perform automated machine learning (AutoML). The default is <code>false</code>. For this case, you
         * must specify <code>recipeArn</code>.
         * </p>
         * <p>
         * When set to <code>true</code>, Amazon Personalize analyzes your training data and selects the optimal
         * USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit <code>recipeArn</code>. Amazon
         * Personalize determines the optimal recipe by running tests with different values for the hyperparameters.
         * AutoML lengthens the training process as compared to selecting a specific recipe.
         * </p>
         * 
         * @param performAutoML
         *        <p>
         *        We don't recommend enabling automated machine learning. Instead, match your use case to the available
         *        Amazon Personalize recipes. For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your
         *        use case.</a>
         *        </p>
         *        </important>
         *        <p>
         *        Whether to perform automated machine learning (AutoML). The default is <code>false</code>. For this
         *        case, you must specify <code>recipeArn</code>.
         *        </p>
         *        <p>
         *        When set to <code>true</code>, Amazon Personalize analyzes your training data and selects the optimal
         *        USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit <code>recipeArn</code>.
         *        Amazon Personalize determines the optimal recipe by running tests with different values for the
         *        hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoML(Boolean performAutoML);

        /**
         * <p>
         * The ARN of the recipe to use for model training. This is required when <code>performAutoML</code> is false.
         * </p>
         * 
         * @param recipeArn
         *        The ARN of the recipe to use for model training. This is required when <code>performAutoML</code> is
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * When your have multiple event types (using an <code>EVENT_TYPE</code> schema field), this parameter specifies
         * which event type (for example, 'click' or 'like') is used for training the model.
         * </p>
         * <p>
         * If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training
         * with equal weight regardless of type.
         * </p>
         * 
         * @param eventType
         *        When your have multiple event types (using an <code>EVENT_TYPE</code> schema field), this parameter
         *        specifies which event type (for example, 'click' or 'like') is used for training the model.</p>
         *        <p>
         *        If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for
         *        training with equal weight regardless of type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The configuration to use with the solution. When <code>performAutoML</code> is set to true, Amazon
         * Personalize only evaluates the <code>autoMLConfig</code> section of the solution configuration.
         * </p>
         * <note>
         * <p>
         * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         * </p>
         * </note>
         * 
         * @param solutionConfig
         *        The configuration to use with the solution. When <code>performAutoML</code> is set to true, Amazon
         *        Personalize only evaluates the <code>autoMLConfig</code> section of the solution configuration.</p>
         *        <note>
         *        <p>
         *        Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionConfig(SolutionConfig solutionConfig);

        /**
         * <p>
         * The configuration to use with the solution. When <code>performAutoML</code> is set to true, Amazon
         * Personalize only evaluates the <code>autoMLConfig</code> section of the solution configuration.
         * </p>
         * <note>
         * <p>
         * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link SolutionConfig.Builder} avoiding
         * the need to create one manually via {@link SolutionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SolutionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #solutionConfig(SolutionConfig)}.
         * 
         * @param solutionConfig
         *        a consumer that will call methods on {@link SolutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionConfig(SolutionConfig)
         */
        default Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return solutionConfig(SolutionConfig.builder().applyMutation(solutionConfig).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean performHPO;

        private Boolean performAutoML;

        private String recipeArn;

        private String datasetGroupArn;

        private String eventType;

        private SolutionConfig solutionConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolutionRequest model) {
            super(model);
            name(model.name);
            performHPO(model.performHPO);
            performAutoML(model.performAutoML);
            recipeArn(model.recipeArn);
            datasetGroupArn(model.datasetGroupArn);
            eventType(model.eventType);
            solutionConfig(model.solutionConfig);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPerformHPO() {
            return performHPO;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final Boolean getPerformAutoML() {
            return performAutoML;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return solutionConfig != null ? solutionConfig.toBuilder() : null;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        @Override
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolutionRequest build() {
            return new CreateSolutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
