/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolutionVersionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateSolutionVersionRequest.Builder, CreateSolutionVersionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSolutionVersionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionArn").getter(getter(CreateSolutionVersionRequest::solutionArn))
            .setter(setter(Builder::solutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()).build();

    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingMode").getter(getter(CreateSolutionVersionRequest::trainingModeAsString))
            .setter(setter(Builder::trainingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateSolutionVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SOLUTION_ARN_FIELD, TRAINING_MODE_FIELD, TAGS_FIELD));

    private final String name;

    private final String solutionArn;

    private final String trainingMode;

    private final List<Tag> tags;

    private CreateSolutionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.solutionArn = builder.solutionArn;
        this.trainingMode = builder.trainingMode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the solution version.
     * </p>
     * 
     * @return The name of the solution version.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     */
    public final String solutionArn() {
        return solutionArn;
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the
     * solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code>
     * option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code>
     * when you want to incrementally update your solution version instead of creating an entirely new one.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used when you already have an active solution version created from the
     * input solution using the <code>FULL</code> option and the input solution was trained with the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     * >User-Personalization</a> recipe or the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a>
     * recipe.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. The <code>FULL</code> option
     *         trains the solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
     *         Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of
     *         creating an entirely new one.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used when you already have an active solution version created
     *         from the input solution using the <code>FULL</code> option and the input solution was trained with the <a
     *         href
     *         ="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">
     *         User-Personalization</a> recipe or the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html"
     *         >HRNN-Coldstart</a> recipe.
     *         </p>
     * @see TrainingMode
     */
    public final TrainingMode trainingMode() {
        return TrainingMode.fromValue(trainingMode);
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the
     * solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code>
     * option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code>
     * when you want to incrementally update your solution version instead of creating an entirely new one.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used when you already have an active solution version created from the
     * input solution using the <code>FULL</code> option and the input solution was trained with the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     * >User-Personalization</a> recipe or the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a>
     * recipe.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. The <code>FULL</code> option
     *         trains the solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
     *         Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of
     *         creating an entirely new one.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used when you already have an active solution version created
     *         from the input solution using the <code>FULL</code> option and the input solution was trained with the <a
     *         href
     *         ="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">
     *         User-Personalization</a> recipe or the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html"
     *         >HRNN-Coldstart</a> recipe.
     *         </p>
     * @see TrainingMode
     */
    public final String trainingModeAsString() {
        return trainingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the solution version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the solution version.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolutionVersionRequest)) {
            return false;
        }
        CreateSolutionVersionRequest other = (CreateSolutionVersionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(solutionArn(), other.solutionArn())
                && Objects.equals(trainingModeAsString(), other.trainingModeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSolutionVersionRequest").add("Name", name()).add("SolutionArn", solutionArn())
                .add("TrainingMode", trainingModeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "solutionArn":
            return Optional.ofNullable(clazz.cast(solutionArn()));
        case "trainingMode":
            return Optional.ofNullable(clazz.cast(trainingModeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolutionVersionRequest, T> g) {
        return obj -> g.apply((CreateSolutionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolutionVersionRequest> {
        /**
         * <p>
         * The name of the solution version.
         * </p>
         * 
         * @param name
         *        The name of the solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         * </p>
         * 
         * @param solutionArn
         *        The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionArn(String solutionArn);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains
         * the solution version based on the entirety of the input solution's training data, while the
         * <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
         * Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an
         * entirely new one.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used when you already have an active solution version created from
         * the input solution using the <code>FULL</code> option and the input solution was trained with the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         * >User-Personalization</a> recipe or the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a>
         * recipe.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. The <code>FULL</code> option
         *        trains the solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the data that has changed in comparison to the input
         *        solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version
         *        instead of creating an entirely new one.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used when you already have an active solution version
         *        created from the input solution using the <code>FULL</code> option and the input solution was trained
         *        with the <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         *        >User-Personalization</a> recipe or the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html"
         *        >HRNN-Coldstart</a> recipe.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(String trainingMode);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains
         * the solution version based on the entirety of the input solution's training data, while the
         * <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
         * Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an
         * entirely new one.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used when you already have an active solution version created from
         * the input solution using the <code>FULL</code> option and the input solution was trained with the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         * >User-Personalization</a> recipe or the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a>
         * recipe.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. The <code>FULL</code> option
         *        trains the solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the data that has changed in comparison to the input
         *        solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version
         *        instead of creating an entirely new one.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used when you already have an active solution version
         *        created from the input solution using the <code>FULL</code> option and the input solution was trained
         *        with the <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         *        >User-Personalization</a> recipe or the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html"
         *        >HRNN-Coldstart</a> recipe.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(TrainingMode trainingMode);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution version.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution version.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the solution version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String solutionArn;

        private String trainingMode;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolutionVersionRequest model) {
            super(model);
            name(model.name);
            solutionArn(model.solutionArn);
            trainingMode(model.trainingMode);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSolutionArn() {
            return solutionArn;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final String getTrainingMode() {
            return trainingMode;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolutionVersionRequest build() {
            return new CreateSolutionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
