/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDatasetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaArn").getter(getter(CreateDatasetRequest::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(CreateDatasetRequest::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetType").getter(getter(CreateDatasetRequest::datasetType)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEMA_ARN_FIELD,
            DATASET_GROUP_ARN_FIELD, DATASET_TYPE_FIELD, TAGS_FIELD));

    private final String name;

    private final String schemaArn;

    private final String datasetGroupArn;

    private final String datasetType;

    private final List<Tag> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schemaArn = builder.schemaArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetType = builder.datasetType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the dataset.
     * </p>
     * 
     * @return The name for the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the schema to associate with the dataset. The schema defines the dataset fields.
     * </p>
     * 
     * @return The ARN of the schema to associate with the dataset. The schema defines the dataset fields.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The type of dataset.
     * </p>
     * <p>
     * One of the following (case insensitive) values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of dataset.</p>
     *         <p>
     *         One of the following (case insensitive) values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Interactions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Items
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Users
     *         </p>
     *         </li>
     */
    public final String datasetType() {
        return datasetType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the dataset.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(schemaArn(), other.schemaArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(datasetType(), other.datasetType()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("Name", name()).add("SchemaArn", schemaArn())
                .add("DatasetGroupArn", datasetGroupArn()).add("DatasetType", datasetType())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "schemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "datasetType":
            return Optional.ofNullable(clazz.cast(datasetType()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * The name for the dataset.
         * </p>
         * 
         * @param name
         *        The name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the schema to associate with the dataset. The schema defines the dataset fields.
         * </p>
         * 
         * @param schemaArn
         *        The ARN of the schema to associate with the dataset. The schema defines the dataset fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The type of dataset.
         * </p>
         * <p>
         * One of the following (case insensitive) values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Interactions
         * </p>
         * </li>
         * <li>
         * <p>
         * Items
         * </p>
         * </li>
         * <li>
         * <p>
         * Users
         * </p>
         * </li>
         * </ul>
         * 
         * @param datasetType
         *        The type of dataset.</p>
         *        <p>
         *        One of the following (case insensitive) values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Interactions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Items
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Users
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the dataset.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the dataset.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String schemaArn;

        private String datasetGroupArn;

        private String datasetType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            name(model.name);
            schemaArn(model.schemaArn);
            datasetGroupArn(model.datasetGroupArn);
            datasetType(model.datasetType);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
