/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCampaignRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateCampaignRequest.Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(CreateCampaignRequest::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minProvisionedTPS").getter(getter(CreateCampaignRequest::minProvisionedTPS))
            .setter(setter(Builder::minProvisionedTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()).build();

    private static final SdkField<CampaignConfig> CAMPAIGN_CONFIG_FIELD = SdkField
            .<CampaignConfig> builder(MarshallingType.SDK_POJO).memberName("campaignConfig")
            .getter(getter(CreateCampaignRequest::campaignConfig)).setter(setter(Builder::campaignConfig))
            .constructor(CampaignConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCampaignRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD, CAMPAIGN_CONFIG_FIELD, TAGS_FIELD));

    private final String name;

    private final String solutionVersionArn;

    private final Integer minProvisionedTPS;

    private final CampaignConfig campaignConfig;

    private final List<Tag> tags;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
        this.campaignConfig = builder.campaignConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     * 
     * @return A name for the new campaign. The campaign name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version to deploy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version to deploy.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * 
     * @return Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
     *         Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend
     *         starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon
     *         CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.
     */
    public final Integer minProvisionedTPS() {
        return minProvisionedTPS;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @return The configuration details of a campaign.
     */
    public final CampaignConfig campaignConfig() {
        return campaignConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the campaign.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(minProvisionedTPS());
        hashCode = 31 * hashCode + Objects.hashCode(campaignConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(minProvisionedTPS(), other.minProvisionedTPS())
                && Objects.equals(campaignConfig(), other.campaignConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCampaignRequest").add("Name", name()).add("SolutionVersionArn", solutionVersionArn())
                .add("MinProvisionedTPS", minProvisionedTPS()).add("CampaignConfig", campaignConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "minProvisionedTPS":
            return Optional.ofNullable(clazz.cast(minProvisionedTPS()));
        case "campaignConfig":
            return Optional.ofNullable(clazz.cast(campaignConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCampaignRequest> {
        /**
         * <p>
         * A name for the new campaign. The campaign name must be unique within your account.
         * </p>
         * 
         * @param name
         *        A name for the new campaign. The campaign name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version to deploy.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
         * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
         * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase
         * the <code>minProvisionedTPS</code> as necessary.
         * </p>
         * 
         * @param minProvisionedTPS
         *        Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
         *        Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend
         *        starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon
         *        CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minProvisionedTPS(Integer minProvisionedTPS);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * 
         * @param campaignConfig
         *        The configuration details of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignConfig(CampaignConfig campaignConfig);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignConfig.Builder} avoiding the need
         * to create one manually via {@link CampaignConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignConfig(CampaignConfig)}.
         * 
         * @param campaignConfig
         *        a consumer that will call methods on {@link CampaignConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignConfig(CampaignConfig)
         */
        default Builder campaignConfig(Consumer<CampaignConfig.Builder> campaignConfig) {
            return campaignConfig(CampaignConfig.builder().applyMutation(campaignConfig).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the campaign.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the campaign.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the campaign.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String solutionVersionArn;

        private Integer minProvisionedTPS;

        private CampaignConfig campaignConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            name(model.name);
            solutionVersionArn(model.solutionVersionArn);
            minProvisionedTPS(model.minProvisionedTPS);
            campaignConfig(model.campaignConfig);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getMinProvisionedTPS() {
            return minProvisionedTPS;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        @Override
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final CampaignConfig.Builder getCampaignConfig() {
            return campaignConfig != null ? campaignConfig.toBuilder() : null;
        }

        public final void setCampaignConfig(CampaignConfig.BuilderImpl campaignConfig) {
            this.campaignConfig = campaignConfig != null ? campaignConfig.build() : null;
        }

        @Override
        public final Builder campaignConfig(CampaignConfig campaignConfig) {
            this.campaignConfig = campaignConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
