/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of a batch inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchInferenceJobConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchInferenceJobConfig.Builder, BatchInferenceJobConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("itemExplorationConfig")
            .getter(getter(BatchInferenceJobConfig::itemExplorationConfig))
            .setter(setter(Builder::itemExplorationConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> itemExplorationConfig;

    private BatchInferenceJobConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemExplorationConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasItemExplorationConfig() {
        return itemExplorationConfig != null && !(itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string to string map specifying the exploration configuration hyperparameters, including
     * <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount
     * of item exploration Amazon Personalize uses when recommending items. See <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     * >User-Personalization</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemExplorationConfig} method.
     * </p>
     * 
     * @return A string to string map specifying the exploration configuration hyperparameters, including
     *         <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure
     *         the amount of item exploration Amazon Personalize uses when recommending items. See <a href=
     *         "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     *         >User-Personalization</a>.
     */
    public final Map<String, String> itemExplorationConfig() {
        return itemExplorationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItemExplorationConfig() ? itemExplorationConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobConfig)) {
            return false;
        }
        BatchInferenceJobConfig other = (BatchInferenceJobConfig) obj;
        return hasItemExplorationConfig() == other.hasItemExplorationConfig()
                && Objects.equals(itemExplorationConfig(), other.itemExplorationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchInferenceJobConfig")
                .add("ItemExplorationConfig", hasItemExplorationConfig() ? itemExplorationConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemExplorationConfig":
            return Optional.ofNullable(clazz.cast(itemExplorationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobConfig, T> g) {
        return obj -> g.apply((BatchInferenceJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchInferenceJobConfig> {
        /**
         * <p>
         * A string to string map specifying the exploration configuration hyperparameters, including
         * <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the
         * amount of item exploration Amazon Personalize uses when recommending items. See <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         * >User-Personalization</a>.
         * </p>
         * 
         * @param itemExplorationConfig
         *        A string to string map specifying the exploration configuration hyperparameters, including
         *        <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure
         *        the amount of item exploration Amazon Personalize uses when recommending items. See <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         *        >User-Personalization</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemExplorationConfig(Map<String, String> itemExplorationConfig);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobConfig model) {
            itemExplorationConfig(model.itemExplorationConfig);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        @Override
        public BatchInferenceJobConfig build() {
            return new BatchInferenceJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
