/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Active Directory compatible certificate template. Connectors issue certificates against these templates based on
 * the requestor's Active Directory group membership.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Template implements SdkPojo, Serializable, ToCopyableBuilder<Template.Builder, Template> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Template::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(Template::connectorArn)).setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Template::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<TemplateDefinition> DEFINITION_FIELD = SdkField
            .<TemplateDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition").getter(getter(Template::definition))
            .setter(setter(Builder::definition)).constructor(TemplateDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Template::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectIdentifier").getter(getter(Template::objectIdentifier)).setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final SdkField<Integer> POLICY_SCHEMA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicySchema").getter(getter(Template::policySchema)).setter(setter(Builder::policySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySchema").build()).build();

    private static final SdkField<TemplateRevision> REVISION_FIELD = SdkField
            .<TemplateRevision> builder(MarshallingType.SDK_POJO).memberName("Revision").getter(getter(Template::revision))
            .setter(setter(Builder::revision)).constructor(TemplateRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Template::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Template::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONNECTOR_ARN_FIELD, CREATED_AT_FIELD, DEFINITION_FIELD, NAME_FIELD, OBJECT_IDENTIFIER_FIELD, POLICY_SCHEMA_FIELD,
            REVISION_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String connectorArn;

    private final Instant createdAt;

    private final TemplateDefinition definition;

    private final String name;

    private final String objectIdentifier;

    private final Integer policySchema;

    private final TemplateRevision revision;

    private final String status;

    private final Instant updatedAt;

    private Template(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectorArn = builder.connectorArn;
        this.createdAt = builder.createdAt;
        this.definition = builder.definition;
        this.name = builder.name;
        this.objectIdentifier = builder.objectIdentifier;
        this.policySchema = builder.policySchema;
        this.revision = builder.revision;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     * >CreateTemplate</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     *         >CreateTemplate</a>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     * >CreateConnector</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     *         >CreateConnector</a>.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The date and time that the template was created.
     * </p>
     * 
     * @return The date and time that the template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @return Template configuration to define the information included in certificates. Define certificate validity
     *         and renewal periods, certificate request handling and enrollment options, key usage extensions,
     *         application policies, and cryptography settings.
     */
    public final TemplateDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * Name of the templates. Template names must be unique.
     * </p>
     * 
     * @return Name of the templates. Template names must be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Object identifier of a template.
     * </p>
     * 
     * @return Object identifier of a template.
     */
    public final String objectIdentifier() {
        return objectIdentifier;
    }

    /**
     * <p>
     * The template schema version. Template schema versions can be v2, v3, or v4. The template configuration options
     * change based on the template schema version.
     * </p>
     * 
     * @return The template schema version. Template schema versions can be v2, v3, or v4. The template configuration
     *         options change based on the template schema version.
     */
    public final Integer policySchema() {
        return policySchema;
    }

    /**
     * <p>
     * The version of the template. Template updates will increment the minor revision. Re-enrolling all certificate
     * holders will increment the major revision.
     * </p>
     * 
     * @return The version of the template. Template updates will increment the minor revision. Re-enrolling all
     *         certificate holders will increment the major revision.
     */
    public final TemplateRevision revision() {
        return revision;
    }

    /**
     * <p>
     * Status of the template. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the template. Status can be creating, active, deleting, or failed.
     * @see TemplateStatus
     */
    public final TemplateStatus status() {
        return TemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the template. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the template. Status can be creating, active, deleting, or failed.
     * @see TemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the template was updated.
     * </p>
     * 
     * @return The date and time that the template was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(policySchema());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(connectorArn(), other.connectorArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(definition(), other.definition())
                && Objects.equals(name(), other.name()) && Objects.equals(objectIdentifier(), other.objectIdentifier())
                && Objects.equals(policySchema(), other.policySchema()) && Objects.equals(revision(), other.revision())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Template").add("Arn", arn()).add("ConnectorArn", connectorArn()).add("CreatedAt", createdAt())
                .add("Definition", definition()).add("Name", name()).add("ObjectIdentifier", objectIdentifier())
                .add("PolicySchema", policySchema()).add("Revision", revision()).add("Status", statusAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        case "PolicySchema":
            return Optional.ofNullable(clazz.cast(policySchema()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Template> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         * >CreateTemplate</a>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         *        >CreateTemplate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         * >CreateConnector</a>.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         *        >CreateConnector</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The date and time that the template was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * 
         * @param definition
         *        Template configuration to define the information included in certificates. Define certificate validity
         *        and renewal periods, certificate request handling and enrollment options, key usage extensions,
         *        application policies, and cryptography settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(TemplateDefinition definition);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateDefinition.Builder} avoiding the
         * need to create one manually via {@link TemplateDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(TemplateDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link TemplateDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(TemplateDefinition)
         */
        default Builder definition(Consumer<TemplateDefinition.Builder> definition) {
            return definition(TemplateDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * Name of the templates. Template names must be unique.
         * </p>
         * 
         * @param name
         *        Name of the templates. Template names must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Object identifier of a template.
         * </p>
         * 
         * @param objectIdentifier
         *        Object identifier of a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);

        /**
         * <p>
         * The template schema version. Template schema versions can be v2, v3, or v4. The template configuration
         * options change based on the template schema version.
         * </p>
         * 
         * @param policySchema
         *        The template schema version. Template schema versions can be v2, v3, or v4. The template configuration
         *        options change based on the template schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policySchema(Integer policySchema);

        /**
         * <p>
         * The version of the template. Template updates will increment the minor revision. Re-enrolling all certificate
         * holders will increment the major revision.
         * </p>
         * 
         * @param revision
         *        The version of the template. Template updates will increment the minor revision. Re-enrolling all
         *        certificate holders will increment the major revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(TemplateRevision revision);

        /**
         * <p>
         * The version of the template. Template updates will increment the minor revision. Re-enrolling all certificate
         * holders will increment the major revision.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateRevision.Builder} avoiding the
         * need to create one manually via {@link TemplateRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(TemplateRevision)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link TemplateRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(TemplateRevision)
         */
        default Builder revision(Consumer<TemplateRevision.Builder> revision) {
            return revision(TemplateRevision.builder().applyMutation(revision).build());
        }

        /**
         * <p>
         * Status of the template. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        Status of the template. Status can be creating, active, deleting, or failed.
         * @see TemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the template. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        Status of the template. Status can be creating, active, deleting, or failed.
         * @see TemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStatus
         */
        Builder status(TemplateStatus status);

        /**
         * <p>
         * The date and time that the template was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the template was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String connectorArn;

        private Instant createdAt;

        private TemplateDefinition definition;

        private String name;

        private String objectIdentifier;

        private Integer policySchema;

        private TemplateRevision revision;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            arn(model.arn);
            connectorArn(model.connectorArn);
            createdAt(model.createdAt);
            definition(model.definition);
            name(model.name);
            objectIdentifier(model.objectIdentifier);
            policySchema(model.policySchema);
            revision(model.revision);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final TemplateDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final Integer getPolicySchema() {
            return policySchema;
        }

        public final void setPolicySchema(Integer policySchema) {
            this.policySchema = policySchema;
        }

        @Override
        public final Builder policySchema(Integer policySchema) {
            this.policySchema = policySchema;
            return this;
        }

        public final TemplateRevision.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        public final void setRevision(TemplateRevision.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(TemplateRevision revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Template build() {
            return new Template(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
