/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServicePrincipalNameResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<GetServicePrincipalNameResponse.Builder, GetServicePrincipalNameResponse> {
    private static final SdkField<ServicePrincipalName> SERVICE_PRINCIPAL_NAME_FIELD = SdkField
            .<ServicePrincipalName> builder(MarshallingType.SDK_POJO).memberName("ServicePrincipalName")
            .getter(getter(GetServicePrincipalNameResponse::servicePrincipalName)).setter(setter(Builder::servicePrincipalName))
            .constructor(ServicePrincipalName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipalName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_NAME_FIELD));

    private final ServicePrincipalName servicePrincipalName;

    private GetServicePrincipalNameResponse(BuilderImpl builder) {
        super(builder);
        this.servicePrincipalName = builder.servicePrincipalName;
    }

    /**
     * <p>
     * The service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     * 
     * @return The service principal name that the connector uses to authenticate with Active Directory.
     */
    public final ServicePrincipalName servicePrincipalName() {
        return servicePrincipalName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipalName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServicePrincipalNameResponse)) {
            return false;
        }
        GetServicePrincipalNameResponse other = (GetServicePrincipalNameResponse) obj;
        return Objects.equals(servicePrincipalName(), other.servicePrincipalName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServicePrincipalNameResponse").add("ServicePrincipalName", servicePrincipalName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipalName":
            return Optional.ofNullable(clazz.cast(servicePrincipalName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServicePrincipalNameResponse, T> g) {
        return obj -> g.apply((GetServicePrincipalNameResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServicePrincipalNameResponse> {
        /**
         * <p>
         * The service principal name that the connector uses to authenticate with Active Directory.
         * </p>
         * 
         * @param servicePrincipalName
         *        The service principal name that the connector uses to authenticate with Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipalName(ServicePrincipalName servicePrincipalName);

        /**
         * <p>
         * The service principal name that the connector uses to authenticate with Active Directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServicePrincipalName.Builder} avoiding
         * the need to create one manually via {@link ServicePrincipalName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServicePrincipalName.Builder#build()} is called immediately and
         * its result is passed to {@link #servicePrincipalName(ServicePrincipalName)}.
         * 
         * @param servicePrincipalName
         *        a consumer that will call methods on {@link ServicePrincipalName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servicePrincipalName(ServicePrincipalName)
         */
        default Builder servicePrincipalName(Consumer<ServicePrincipalName.Builder> servicePrincipalName) {
            return servicePrincipalName(ServicePrincipalName.builder().applyMutation(servicePrincipalName).build());
        }
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private ServicePrincipalName servicePrincipalName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServicePrincipalNameResponse model) {
            super(model);
            servicePrincipalName(model.servicePrincipalName);
        }

        public final ServicePrincipalName.Builder getServicePrincipalName() {
            return servicePrincipalName != null ? servicePrincipalName.toBuilder() : null;
        }

        public final void setServicePrincipalName(ServicePrincipalName.BuilderImpl servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName != null ? servicePrincipalName.build() : null;
        }

        @Override
        public final Builder servicePrincipalName(ServicePrincipalName servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            return this;
        }

        @Override
        public GetServicePrincipalNameResponse build() {
            return new GetServicePrincipalNameResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
