/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The directory registration represents the authorization of the connector service with the Active Directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectoryRegistrationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectoryRegistrationSummary.Builder, DirectoryRegistrationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DirectoryRegistrationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DirectoryRegistrationSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DirectoryRegistrationSummary::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DirectoryRegistrationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DirectoryRegistrationSummary::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DirectoryRegistrationSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DIRECTORY_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String directoryId;

    private final String status;

    private final String statusReason;

    private final Instant updatedAt;

    private DirectoryRegistrationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.directoryId = builder.directoryId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     * >CreateDirectoryRegistration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     *         >CreateDirectoryRegistration</a>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the directory registration was created.
     * </p>
     * 
     * @return The date and time that the directory registration was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the Active Directory.
     * </p>
     * 
     * @return The identifier of the Active Directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * Status of the directory registration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DirectoryRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the directory registration.
     * @see DirectoryRegistrationStatus
     */
    public final DirectoryRegistrationStatus status() {
        return DirectoryRegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the directory registration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DirectoryRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the directory registration.
     * @see DirectoryRegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the directory registration status if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link DirectoryRegistrationStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information about the directory registration status if the status is failed.
     * @see DirectoryRegistrationStatusReason
     */
    public final DirectoryRegistrationStatusReason statusReason() {
        return DirectoryRegistrationStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * Additional information about the directory registration status if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link DirectoryRegistrationStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information about the directory registration status if the status is failed.
     * @see DirectoryRegistrationStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time that the directory registration was updated.
     * </p>
     * 
     * @return The date and time that the directory registration was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryRegistrationSummary)) {
            return false;
        }
        DirectoryRegistrationSummary other = (DirectoryRegistrationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(directoryId(), other.directoryId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectoryRegistrationSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("DirectoryId", directoryId()).add("Status", statusAsString()).add("StatusReason", statusReasonAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryRegistrationSummary, T> g) {
        return obj -> g.apply((DirectoryRegistrationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectoryRegistrationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a href=
         * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         * >CreateDirectoryRegistration</a>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that was returned when you called <a href=
         *        "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         *        >CreateDirectoryRegistration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the directory registration was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the directory registration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the Active Directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * Status of the directory registration.
         * </p>
         * 
         * @param status
         *        Status of the directory registration.
         * @see DirectoryRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryRegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the directory registration.
         * </p>
         * 
         * @param status
         *        Status of the directory registration.
         * @see DirectoryRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryRegistrationStatus
         */
        Builder status(DirectoryRegistrationStatus status);

        /**
         * <p>
         * Additional information about the directory registration status if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the directory registration status if the status is failed.
         * @see DirectoryRegistrationStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryRegistrationStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Additional information about the directory registration status if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the directory registration status if the status is failed.
         * @see DirectoryRegistrationStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryRegistrationStatusReason
         */
        Builder statusReason(DirectoryRegistrationStatusReason statusReason);

        /**
         * <p>
         * The date and time that the directory registration was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the directory registration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String directoryId;

        private String status;

        private String statusReason;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryRegistrationSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            directoryId(model.directoryId);
            status(model.status);
            statusReason(model.statusReason);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DirectoryRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(DirectoryRegistrationStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DirectoryRegistrationSummary build() {
            return new DirectoryRegistrationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
