/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionKeyMastercard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionKeyMastercard> {
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationTransactionCounter").getter(SessionKeyMastercard.getter(SessionKeyMastercard::applicationTransactionCounter)).setter(SessionKeyMastercard.setter(Builder::applicationTransactionCounter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(SessionKeyMastercard.getter(SessionKeyMastercard::panSequenceNumber)).setter(SessionKeyMastercard.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(SessionKeyMastercard.getter(SessionKeyMastercard::primaryAccountNumber)).setter(SessionKeyMastercard.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> UNPREDICTABLE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnpredictableNumber").getter(SessionKeyMastercard.getter(SessionKeyMastercard::unpredictableNumber)).setter(SessionKeyMastercard.setter(Builder::unpredictableNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpredictableNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_TRANSACTION_COUNTER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, UNPREDICTABLE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationTransactionCounter;
    private final String panSequenceNumber;
    private final String primaryAccountNumber;
    private final String unpredictableNumber;

    private SessionKeyMastercard(BuilderImpl builder) {
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.unpredictableNumber = builder.unpredictableNumber;
    }

    public final String applicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String unpredictableNumber() {
        return this.unpredictableNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.unpredictableNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyMastercard)) {
            return false;
        }
        SessionKeyMastercard other = (SessionKeyMastercard)obj;
        return Objects.equals(this.applicationTransactionCounter(), other.applicationTransactionCounter()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.unpredictableNumber(), other.unpredictableNumber());
    }

    public final String toString() {
        return ToString.builder((String)"SessionKeyMastercard").add("ApplicationTransactionCounter", (Object)this.applicationTransactionCounter()).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("UnpredictableNumber", (Object)this.unpredictableNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationTransactionCounter": {
                return Optional.ofNullable(clazz.cast(this.applicationTransactionCounter()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "UnpredictableNumber": {
                return Optional.ofNullable(clazz.cast(this.unpredictableNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyMastercard, T> g) {
        return obj -> g.apply((SessionKeyMastercard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationTransactionCounter;
        private String panSequenceNumber;
        private String primaryAccountNumber;
        private String unpredictableNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyMastercard model) {
            this.applicationTransactionCounter(model.applicationTransactionCounter);
            this.panSequenceNumber(model.panSequenceNumber);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.unpredictableNumber(model.unpredictableNumber);
        }

        public final String getApplicationTransactionCounter() {
            return this.applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getUnpredictableNumber() {
            return this.unpredictableNumber;
        }

        public final void setUnpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
        }

        @Override
        public final Builder unpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
            return this;
        }

        public SessionKeyMastercard build() {
            return new SessionKeyMastercard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionKeyMastercard> {
        public Builder applicationTransactionCounter(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder primaryAccountNumber(String var1);

        public Builder unpredictableNumber(String var1);
    }
}

