/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReEncryptDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, ReEncryptDataRequest> {
    private static final SdkField<String> CIPHER_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CipherText").getter(ReEncryptDataRequest.getter(ReEncryptDataRequest::cipherText)).setter(ReEncryptDataRequest.setter(Builder::cipherText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CipherText").build()}).build();
    private static final SdkField<ReEncryptionAttributes> INCOMING_ENCRYPTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingEncryptionAttributes").getter(ReEncryptDataRequest.getter(ReEncryptDataRequest::incomingEncryptionAttributes)).setter(ReEncryptDataRequest.setter(Builder::incomingEncryptionAttributes)).constructor(ReEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingEncryptionAttributes").build()}).build();
    private static final SdkField<String> INCOMING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncomingKeyIdentifier").getter(ReEncryptDataRequest.getter(ReEncryptDataRequest::incomingKeyIdentifier)).setter(ReEncryptDataRequest.setter(Builder::incomingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IncomingKeyIdentifier").build()}).build();
    private static final SdkField<ReEncryptionAttributes> OUTGOING_ENCRYPTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutgoingEncryptionAttributes").getter(ReEncryptDataRequest.getter(ReEncryptDataRequest::outgoingEncryptionAttributes)).setter(ReEncryptDataRequest.setter(Builder::outgoingEncryptionAttributes)).constructor(ReEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingEncryptionAttributes").build()}).build();
    private static final SdkField<String> OUTGOING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutgoingKeyIdentifier").getter(ReEncryptDataRequest.getter(ReEncryptDataRequest::outgoingKeyIdentifier)).setter(ReEncryptDataRequest.setter(Builder::outgoingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHER_TEXT_FIELD, INCOMING_ENCRYPTION_ATTRIBUTES_FIELD, INCOMING_KEY_IDENTIFIER_FIELD, OUTGOING_ENCRYPTION_ATTRIBUTES_FIELD, OUTGOING_KEY_IDENTIFIER_FIELD));
    private final String cipherText;
    private final ReEncryptionAttributes incomingEncryptionAttributes;
    private final String incomingKeyIdentifier;
    private final ReEncryptionAttributes outgoingEncryptionAttributes;
    private final String outgoingKeyIdentifier;

    private ReEncryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.cipherText = builder.cipherText;
        this.incomingEncryptionAttributes = builder.incomingEncryptionAttributes;
        this.incomingKeyIdentifier = builder.incomingKeyIdentifier;
        this.outgoingEncryptionAttributes = builder.outgoingEncryptionAttributes;
        this.outgoingKeyIdentifier = builder.outgoingKeyIdentifier;
    }

    public final String cipherText() {
        return this.cipherText;
    }

    public final ReEncryptionAttributes incomingEncryptionAttributes() {
        return this.incomingEncryptionAttributes;
    }

    public final String incomingKeyIdentifier() {
        return this.incomingKeyIdentifier;
    }

    public final ReEncryptionAttributes outgoingEncryptionAttributes() {
        return this.outgoingEncryptionAttributes;
    }

    public final String outgoingKeyIdentifier() {
        return this.outgoingKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cipherText());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingEncryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingEncryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptDataRequest)) {
            return false;
        }
        ReEncryptDataRequest other = (ReEncryptDataRequest)((Object)obj);
        return Objects.equals(this.cipherText(), other.cipherText()) && Objects.equals(this.incomingEncryptionAttributes(), other.incomingEncryptionAttributes()) && Objects.equals(this.incomingKeyIdentifier(), other.incomingKeyIdentifier()) && Objects.equals(this.outgoingEncryptionAttributes(), other.outgoingEncryptionAttributes()) && Objects.equals(this.outgoingKeyIdentifier(), other.outgoingKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ReEncryptDataRequest").add("CipherText", (Object)(this.cipherText() == null ? null : "*** Sensitive Data Redacted ***")).add("IncomingEncryptionAttributes", (Object)this.incomingEncryptionAttributes()).add("IncomingKeyIdentifier", (Object)this.incomingKeyIdentifier()).add("OutgoingEncryptionAttributes", (Object)this.outgoingEncryptionAttributes()).add("OutgoingKeyIdentifier", (Object)this.outgoingKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CipherText": {
                return Optional.ofNullable(clazz.cast(this.cipherText()));
            }
            case "IncomingEncryptionAttributes": {
                return Optional.ofNullable(clazz.cast(this.incomingEncryptionAttributes()));
            }
            case "IncomingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.incomingKeyIdentifier()));
            }
            case "OutgoingEncryptionAttributes": {
                return Optional.ofNullable(clazz.cast(this.outgoingEncryptionAttributes()));
            }
            case "OutgoingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outgoingKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptDataRequest, T> g) {
        return obj -> g.apply((ReEncryptDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String cipherText;
        private ReEncryptionAttributes incomingEncryptionAttributes;
        private String incomingKeyIdentifier;
        private ReEncryptionAttributes outgoingEncryptionAttributes;
        private String outgoingKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptDataRequest model) {
            super(model);
            this.cipherText(model.cipherText);
            this.incomingEncryptionAttributes(model.incomingEncryptionAttributes);
            this.incomingKeyIdentifier(model.incomingKeyIdentifier);
            this.outgoingEncryptionAttributes(model.outgoingEncryptionAttributes);
            this.outgoingKeyIdentifier(model.outgoingKeyIdentifier);
        }

        public final String getCipherText() {
            return this.cipherText;
        }

        public final void setCipherText(String cipherText) {
            this.cipherText = cipherText;
        }

        @Override
        public final Builder cipherText(String cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public final ReEncryptionAttributes.Builder getIncomingEncryptionAttributes() {
            return this.incomingEncryptionAttributes != null ? this.incomingEncryptionAttributes.toBuilder() : null;
        }

        public final void setIncomingEncryptionAttributes(ReEncryptionAttributes.BuilderImpl incomingEncryptionAttributes) {
            this.incomingEncryptionAttributes = incomingEncryptionAttributes != null ? incomingEncryptionAttributes.build() : null;
        }

        @Override
        public final Builder incomingEncryptionAttributes(ReEncryptionAttributes incomingEncryptionAttributes) {
            this.incomingEncryptionAttributes = incomingEncryptionAttributes;
            return this;
        }

        public final String getIncomingKeyIdentifier() {
            return this.incomingKeyIdentifier;
        }

        public final void setIncomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
        }

        @Override
        public final Builder incomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
            return this;
        }

        public final ReEncryptionAttributes.Builder getOutgoingEncryptionAttributes() {
            return this.outgoingEncryptionAttributes != null ? this.outgoingEncryptionAttributes.toBuilder() : null;
        }

        public final void setOutgoingEncryptionAttributes(ReEncryptionAttributes.BuilderImpl outgoingEncryptionAttributes) {
            this.outgoingEncryptionAttributes = outgoingEncryptionAttributes != null ? outgoingEncryptionAttributes.build() : null;
        }

        @Override
        public final Builder outgoingEncryptionAttributes(ReEncryptionAttributes outgoingEncryptionAttributes) {
            this.outgoingEncryptionAttributes = outgoingEncryptionAttributes;
            return this;
        }

        public final String getOutgoingKeyIdentifier() {
            return this.outgoingKeyIdentifier;
        }

        public final void setOutgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
        }

        @Override
        public final Builder outgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReEncryptDataRequest build() {
            return new ReEncryptDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReEncryptDataRequest> {
        public Builder cipherText(String var1);

        public Builder incomingEncryptionAttributes(ReEncryptionAttributes var1);

        default public Builder incomingEncryptionAttributes(Consumer<ReEncryptionAttributes.Builder> incomingEncryptionAttributes) {
            return this.incomingEncryptionAttributes((ReEncryptionAttributes)((ReEncryptionAttributes.Builder)ReEncryptionAttributes.builder().applyMutation(incomingEncryptionAttributes)).build());
        }

        public Builder incomingKeyIdentifier(String var1);

        public Builder outgoingEncryptionAttributes(ReEncryptionAttributes var1);

        default public Builder outgoingEncryptionAttributes(Consumer<ReEncryptionAttributes.Builder> outgoingEncryptionAttributes) {
            return this.outgoingEncryptionAttributes((ReEncryptionAttributes)((ReEncryptionAttributes.Builder)ReEncryptionAttributes.builder().applyMutation(outgoingEncryptionAttributes)).build());
        }

        public Builder outgoingKeyIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

