/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.paymentcryptographydata.DefaultPaymentCryptographyDataClientBuilder;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataClientBuilder;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptographydata.model.AccessDeniedException;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.InternalServerException;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataException;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.paymentcryptographydata.model.ThrottlingException;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.ValidationException;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerificationFailedException;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse;

@SdkPublicApi
@ThreadSafe
public interface PaymentCryptographyDataClient
extends AwsClient {
    public static final String SERVICE_NAME = "payment-cryptography";
    public static final String SERVICE_METADATA_ID = "dataplane.payment-cryptography";

    default public DecryptDataResponse decryptData(DecryptDataRequest decryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public DecryptDataResponse decryptData(Consumer<DecryptDataRequest.Builder> decryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.decryptData((DecryptDataRequest)((Object)((DecryptDataRequest.Builder)DecryptDataRequest.builder().applyMutation(decryptDataRequest)).build()));
    }

    default public EncryptDataResponse encryptData(EncryptDataRequest encryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public EncryptDataResponse encryptData(Consumer<EncryptDataRequest.Builder> encryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.encryptData((EncryptDataRequest)((Object)((EncryptDataRequest.Builder)EncryptDataRequest.builder().applyMutation(encryptDataRequest)).build()));
    }

    default public GenerateCardValidationDataResponse generateCardValidationData(GenerateCardValidationDataRequest generateCardValidationDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public GenerateCardValidationDataResponse generateCardValidationData(Consumer<GenerateCardValidationDataRequest.Builder> generateCardValidationDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.generateCardValidationData((GenerateCardValidationDataRequest)((Object)((GenerateCardValidationDataRequest.Builder)GenerateCardValidationDataRequest.builder().applyMutation(generateCardValidationDataRequest)).build()));
    }

    default public GenerateMacResponse generateMac(GenerateMacRequest generateMacRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public GenerateMacResponse generateMac(Consumer<GenerateMacRequest.Builder> generateMacRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.generateMac((GenerateMacRequest)((Object)((GenerateMacRequest.Builder)GenerateMacRequest.builder().applyMutation(generateMacRequest)).build()));
    }

    default public GeneratePinDataResponse generatePinData(GeneratePinDataRequest generatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public GeneratePinDataResponse generatePinData(Consumer<GeneratePinDataRequest.Builder> generatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.generatePinData((GeneratePinDataRequest)((Object)((GeneratePinDataRequest.Builder)GeneratePinDataRequest.builder().applyMutation(generatePinDataRequest)).build()));
    }

    default public ReEncryptDataResponse reEncryptData(ReEncryptDataRequest reEncryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public ReEncryptDataResponse reEncryptData(Consumer<ReEncryptDataRequest.Builder> reEncryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.reEncryptData((ReEncryptDataRequest)((Object)((ReEncryptDataRequest.Builder)ReEncryptDataRequest.builder().applyMutation(reEncryptDataRequest)).build()));
    }

    default public TranslatePinDataResponse translatePinData(TranslatePinDataRequest translatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public TranslatePinDataResponse translatePinData(Consumer<TranslatePinDataRequest.Builder> translatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.translatePinData((TranslatePinDataRequest)((Object)((TranslatePinDataRequest.Builder)TranslatePinDataRequest.builder().applyMutation(translatePinDataRequest)).build()));
    }

    default public VerifyAuthRequestCryptogramResponse verifyAuthRequestCryptogram(VerifyAuthRequestCryptogramRequest verifyAuthRequestCryptogramRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public VerifyAuthRequestCryptogramResponse verifyAuthRequestCryptogram(Consumer<VerifyAuthRequestCryptogramRequest.Builder> verifyAuthRequestCryptogramRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.verifyAuthRequestCryptogram((VerifyAuthRequestCryptogramRequest)((Object)((VerifyAuthRequestCryptogramRequest.Builder)VerifyAuthRequestCryptogramRequest.builder().applyMutation(verifyAuthRequestCryptogramRequest)).build()));
    }

    default public VerifyCardValidationDataResponse verifyCardValidationData(VerifyCardValidationDataRequest verifyCardValidationDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public VerifyCardValidationDataResponse verifyCardValidationData(Consumer<VerifyCardValidationDataRequest.Builder> verifyCardValidationDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.verifyCardValidationData((VerifyCardValidationDataRequest)((Object)((VerifyCardValidationDataRequest.Builder)VerifyCardValidationDataRequest.builder().applyMutation(verifyCardValidationDataRequest)).build()));
    }

    default public VerifyMacResponse verifyMac(VerifyMacRequest verifyMacRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public VerifyMacResponse verifyMac(Consumer<VerifyMacRequest.Builder> verifyMacRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.verifyMac((VerifyMacRequest)((Object)((VerifyMacRequest.Builder)VerifyMacRequest.builder().applyMutation(verifyMacRequest)).build()));
    }

    default public VerifyPinDataResponse verifyPinData(VerifyPinDataRequest verifyPinDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        throw new UnsupportedOperationException();
    }

    default public VerifyPinDataResponse verifyPinData(Consumer<VerifyPinDataRequest.Builder> verifyPinDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        return this.verifyPinData((VerifyPinDataRequest)((Object)((VerifyPinDataRequest.Builder)VerifyPinDataRequest.builder().applyMutation(verifyPinDataRequest)).build()));
    }

    public static PaymentCryptographyDataClient create() {
        return (PaymentCryptographyDataClient)PaymentCryptographyDataClient.builder().build();
    }

    public static PaymentCryptographyDataClientBuilder builder() {
        return new DefaultPaymentCryptographyDataClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public PaymentCryptographyDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

