/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PaddingType {
    PKCS1("PKCS1"),
    OAEP_SHA1("OAEP_SHA1"),
    OAEP_SHA256("OAEP_SHA256"),
    OAEP_SHA512("OAEP_SHA512"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PaddingType> VALUE_MAP;
    private final String value;

    private PaddingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaddingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaddingType> knownValues() {
        EnumSet<PaddingType> knownValues = EnumSet.allOf(PaddingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PaddingType.class, PaddingType::toString);
    }
}

