/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WrappedKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WrappedKey> {
    private static final SdkField<String> KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterial").getter(WrappedKey.getter(WrappedKey::keyMaterial)).setter(WrappedKey.setter(Builder::keyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyMaterialFormat").getter(WrappedKey.getter(WrappedKey::wrappedKeyMaterialFormatAsString)).setter(WrappedKey.setter(Builder::wrappedKeyMaterialFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterialFormat").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyArn").getter(WrappedKey.getter(WrappedKey::wrappingKeyArn)).setter(WrappedKey.setter(Builder::wrappingKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_FIELD, WRAPPED_KEY_MATERIAL_FORMAT_FIELD, WRAPPING_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyMaterial;
    private final String wrappedKeyMaterialFormat;
    private final String wrappingKeyArn;

    private WrappedKey(BuilderImpl builder) {
        this.keyMaterial = builder.keyMaterial;
        this.wrappedKeyMaterialFormat = builder.wrappedKeyMaterialFormat;
        this.wrappingKeyArn = builder.wrappingKeyArn;
    }

    public final String keyMaterial() {
        return this.keyMaterial;
    }

    public final WrappedKeyMaterialFormat wrappedKeyMaterialFormat() {
        return WrappedKeyMaterialFormat.fromValue(this.wrappedKeyMaterialFormat);
    }

    public final String wrappedKeyMaterialFormatAsString() {
        return this.wrappedKeyMaterialFormat;
    }

    public final String wrappingKeyArn() {
        return this.wrappingKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyMaterialFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedKey)) {
            return false;
        }
        WrappedKey other = (WrappedKey)obj;
        return Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.wrappedKeyMaterialFormatAsString(), other.wrappedKeyMaterialFormatAsString()) && Objects.equals(this.wrappingKeyArn(), other.wrappingKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"WrappedKey").add("KeyMaterial", (Object)(this.keyMaterial() == null ? null : "*** Sensitive Data Redacted ***")).add("WrappedKeyMaterialFormat", (Object)this.wrappedKeyMaterialFormatAsString()).add("WrappingKeyArn", (Object)this.wrappingKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "WrappedKeyMaterialFormat": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyMaterialFormatAsString()));
            }
            case "WrappingKeyArn": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WrappedKey, T> g) {
        return obj -> g.apply((WrappedKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyMaterial;
        private String wrappedKeyMaterialFormat;
        private String wrappingKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedKey model) {
            this.keyMaterial(model.keyMaterial);
            this.wrappedKeyMaterialFormat(model.wrappedKeyMaterialFormat);
            this.wrappingKeyArn(model.wrappingKeyArn);
        }

        public final String getKeyMaterial() {
            return this.keyMaterial;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final String getWrappedKeyMaterialFormat() {
            return this.wrappedKeyMaterialFormat;
        }

        public final void setWrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
            return this;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat(wrappedKeyMaterialFormat == null ? null : wrappedKeyMaterialFormat.toString());
            return this;
        }

        public final String getWrappingKeyArn() {
            return this.wrappingKeyArn;
        }

        public final void setWrappingKeyArn(String wrappingKeyArn) {
            this.wrappingKeyArn = wrappingKeyArn;
        }

        @Override
        public final Builder wrappingKeyArn(String wrappingKeyArn) {
            this.wrappingKeyArn = wrappingKeyArn;
            return this;
        }

        public WrappedKey build() {
            return new WrappedKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WrappedKey> {
        public Builder keyMaterial(String var1);

        public Builder wrappedKeyMaterialFormat(String var1);

        public Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat var1);

        public Builder wrappingKeyArn(String var1);
    }
}

