/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalApplicationInstanceNodeInstancesRequest extends PanoramaRequest implements
        ToCopyableBuilder<SignalApplicationInstanceNodeInstancesRequest.Builder, SignalApplicationInstanceNodeInstancesRequest> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceId")
            .getter(getter(SignalApplicationInstanceNodeInstancesRequest::applicationInstanceId))
            .setter(setter(Builder::applicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationInstanceId").build())
            .build();

    private static final SdkField<List<NodeSignal>> NODE_SIGNALS_FIELD = SdkField
            .<List<NodeSignal>> builder(MarshallingType.LIST)
            .memberName("NodeSignals")
            .getter(getter(SignalApplicationInstanceNodeInstancesRequest::nodeSignals))
            .setter(setter(Builder::nodeSignals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeSignals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeSignal> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeSignal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD,
            NODE_SIGNALS_FIELD));

    private final String applicationInstanceId;

    private final List<NodeSignal> nodeSignals;

    private SignalApplicationInstanceNodeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
        this.nodeSignals = builder.nodeSignals;
    }

    /**
     * <p>
     * An application instance ID.
     * </p>
     * 
     * @return An application instance ID.
     */
    public final String applicationInstanceId() {
        return applicationInstanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeSignals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeSignals() {
        return nodeSignals != null && !(nodeSignals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeSignals} method.
     * </p>
     * 
     * @return A list of signals.
     */
    public final List<NodeSignal> nodeSignals() {
        return nodeSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeSignals() ? nodeSignals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalApplicationInstanceNodeInstancesRequest)) {
            return false;
        }
        SignalApplicationInstanceNodeInstancesRequest other = (SignalApplicationInstanceNodeInstancesRequest) obj;
        return Objects.equals(applicationInstanceId(), other.applicationInstanceId())
                && hasNodeSignals() == other.hasNodeSignals() && Objects.equals(nodeSignals(), other.nodeSignals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalApplicationInstanceNodeInstancesRequest")
                .add("ApplicationInstanceId", applicationInstanceId())
                .add("NodeSignals", hasNodeSignals() ? nodeSignals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(applicationInstanceId()));
        case "NodeSignals":
            return Optional.ofNullable(clazz.cast(nodeSignals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalApplicationInstanceNodeInstancesRequest, T> g) {
        return obj -> g.apply((SignalApplicationInstanceNodeInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SignalApplicationInstanceNodeInstancesRequest> {
        /**
         * <p>
         * An application instance ID.
         * </p>
         * 
         * @param applicationInstanceId
         *        An application instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceId(String applicationInstanceId);

        /**
         * <p>
         * A list of signals.
         * </p>
         * 
         * @param nodeSignals
         *        A list of signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeSignals(Collection<NodeSignal> nodeSignals);

        /**
         * <p>
         * A list of signals.
         * </p>
         * 
         * @param nodeSignals
         *        A list of signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeSignals(NodeSignal... nodeSignals);

        /**
         * <p>
         * A list of signals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.panorama.model.NodeSignal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.panorama.model.NodeSignal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.panorama.model.NodeSignal.Builder#build()} is called immediately and
         * its result is passed to {@link #nodeSignals(List<NodeSignal>)}.
         * 
         * @param nodeSignals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.panorama.model.NodeSignal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeSignals(java.util.Collection<NodeSignal>)
         */
        Builder nodeSignals(Consumer<NodeSignal.Builder>... nodeSignals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String applicationInstanceId;

        private List<NodeSignal> nodeSignals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignalApplicationInstanceNodeInstancesRequest model) {
            super(model);
            applicationInstanceId(model.applicationInstanceId);
            nodeSignals(model.nodeSignals);
        }

        public final String getApplicationInstanceId() {
            return applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final List<NodeSignal.Builder> getNodeSignals() {
            List<NodeSignal.Builder> result = NodeSignalListCopier.copyToBuilder(this.nodeSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeSignals(Collection<NodeSignal.BuilderImpl> nodeSignals) {
            this.nodeSignals = NodeSignalListCopier.copyFromBuilder(nodeSignals);
        }

        @Override
        public final Builder nodeSignals(Collection<NodeSignal> nodeSignals) {
            this.nodeSignals = NodeSignalListCopier.copy(nodeSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSignals(NodeSignal... nodeSignals) {
            nodeSignals(Arrays.asList(nodeSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSignals(Consumer<NodeSignal.Builder>... nodeSignals) {
            nodeSignals(Stream.of(nodeSignals).map(c -> NodeSignal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignalApplicationInstanceNodeInstancesRequest build() {
            return new SignalApplicationInstanceNodeInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
