/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A node instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeInstance implements SdkPojo, Serializable, ToCopyableBuilder<NodeInstance.Builder, NodeInstance> {
    private static final SdkField<String> CURRENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentStatus").getter(getter(NodeInstance::currentStatusAsString))
            .setter(setter(Builder::currentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStatus").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(NodeInstance::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> NODE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeInstanceId").getter(getter(NodeInstance::nodeInstanceId)).setter(setter(Builder::nodeInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstanceId").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeName").getter(getter(NodeInstance::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(NodeInstance::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackagePatchVersion").getter(getter(NodeInstance::packagePatchVersion))
            .setter(setter(Builder::packagePatchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackagePatchVersion").build())
            .build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(NodeInstance::packageVersion)).setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_STATUS_FIELD,
            NODE_ID_FIELD, NODE_INSTANCE_ID_FIELD, NODE_NAME_FIELD, PACKAGE_NAME_FIELD, PACKAGE_PATCH_VERSION_FIELD,
            PACKAGE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentStatus;

    private final String nodeId;

    private final String nodeInstanceId;

    private final String nodeName;

    private final String packageName;

    private final String packagePatchVersion;

    private final String packageVersion;

    private NodeInstance(BuilderImpl builder) {
        this.currentStatus = builder.currentStatus;
        this.nodeId = builder.nodeId;
        this.nodeInstanceId = builder.nodeInstanceId;
        this.nodeName = builder.nodeName;
        this.packageName = builder.packageName;
        this.packagePatchVersion = builder.packagePatchVersion;
        this.packageVersion = builder.packageVersion;
    }

    /**
     * <p>
     * The instance's current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentStatus}
     * will return {@link NodeInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #currentStatusAsString}.
     * </p>
     * 
     * @return The instance's current status.
     * @see NodeInstanceStatus
     */
    public final NodeInstanceStatus currentStatus() {
        return NodeInstanceStatus.fromValue(currentStatus);
    }

    /**
     * <p>
     * The instance's current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentStatus}
     * will return {@link NodeInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #currentStatusAsString}.
     * </p>
     * 
     * @return The instance's current status.
     * @see NodeInstanceStatus
     */
    public final String currentStatusAsString() {
        return currentStatus;
    }

    /**
     * <p>
     * The node's ID.
     * </p>
     * 
     * @return The node's ID.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The instance's ID.
     * </p>
     * 
     * @return The instance's ID.
     */
    public final String nodeInstanceId() {
        return nodeInstanceId;
    }

    /**
     * <p>
     * The instance's name.
     * </p>
     * 
     * @return The instance's name.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The instance's package name.
     * </p>
     * 
     * @return The instance's package name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The instance's package patch version.
     * </p>
     * 
     * @return The instance's package patch version.
     */
    public final String packagePatchVersion() {
        return packagePatchVersion;
    }

    /**
     * <p>
     * The instance's package version.
     * </p>
     * 
     * @return The instance's package version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packagePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInstance)) {
            return false;
        }
        NodeInstance other = (NodeInstance) obj;
        return Objects.equals(currentStatusAsString(), other.currentStatusAsString()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(nodeInstanceId(), other.nodeInstanceId()) && Objects.equals(nodeName(), other.nodeName())
                && Objects.equals(packageName(), other.packageName())
                && Objects.equals(packagePatchVersion(), other.packagePatchVersion())
                && Objects.equals(packageVersion(), other.packageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeInstance").add("CurrentStatus", currentStatusAsString()).add("NodeId", nodeId())
                .add("NodeInstanceId", nodeInstanceId()).add("NodeName", nodeName()).add("PackageName", packageName())
                .add("PackagePatchVersion", packagePatchVersion()).add("PackageVersion", packageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentStatus":
            return Optional.ofNullable(clazz.cast(currentStatusAsString()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "NodeInstanceId":
            return Optional.ofNullable(clazz.cast(nodeInstanceId()));
        case "NodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackagePatchVersion":
            return Optional.ofNullable(clazz.cast(packagePatchVersion()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInstance, T> g) {
        return obj -> g.apply((NodeInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeInstance> {
        /**
         * <p>
         * The instance's current status.
         * </p>
         * 
         * @param currentStatus
         *        The instance's current status.
         * @see NodeInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeInstanceStatus
         */
        Builder currentStatus(String currentStatus);

        /**
         * <p>
         * The instance's current status.
         * </p>
         * 
         * @param currentStatus
         *        The instance's current status.
         * @see NodeInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeInstanceStatus
         */
        Builder currentStatus(NodeInstanceStatus currentStatus);

        /**
         * <p>
         * The node's ID.
         * </p>
         * 
         * @param nodeId
         *        The node's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The instance's ID.
         * </p>
         * 
         * @param nodeInstanceId
         *        The instance's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInstanceId(String nodeInstanceId);

        /**
         * <p>
         * The instance's name.
         * </p>
         * 
         * @param nodeName
         *        The instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The instance's package name.
         * </p>
         * 
         * @param packageName
         *        The instance's package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The instance's package patch version.
         * </p>
         * 
         * @param packagePatchVersion
         *        The instance's package patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagePatchVersion(String packagePatchVersion);

        /**
         * <p>
         * The instance's package version.
         * </p>
         * 
         * @param packageVersion
         *        The instance's package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);
    }

    static final class BuilderImpl implements Builder {
        private String currentStatus;

        private String nodeId;

        private String nodeInstanceId;

        private String nodeName;

        private String packageName;

        private String packagePatchVersion;

        private String packageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInstance model) {
            currentStatus(model.currentStatus);
            nodeId(model.nodeId);
            nodeInstanceId(model.nodeInstanceId);
            nodeName(model.nodeName);
            packageName(model.packageName);
            packagePatchVersion(model.packagePatchVersion);
            packageVersion(model.packageVersion);
        }

        public final String getCurrentStatus() {
            return currentStatus;
        }

        public final void setCurrentStatus(String currentStatus) {
            this.currentStatus = currentStatus;
        }

        @Override
        public final Builder currentStatus(String currentStatus) {
            this.currentStatus = currentStatus;
            return this;
        }

        @Override
        public final Builder currentStatus(NodeInstanceStatus currentStatus) {
            this.currentStatus(currentStatus == null ? null : currentStatus.toString());
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getNodeInstanceId() {
            return nodeInstanceId;
        }

        public final void setNodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
        }

        @Override
        public final Builder nodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackagePatchVersion() {
            return packagePatchVersion;
        }

        public final void setPackagePatchVersion(String packagePatchVersion) {
            this.packagePatchVersion = packagePatchVersion;
        }

        @Override
        public final Builder packagePatchVersion(String packagePatchVersion) {
            this.packagePatchVersion = packagePatchVersion;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        @Override
        public NodeInstance build() {
            return new NodeInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
