/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationInstanceRequest extends PanoramaRequest implements
        ToCopyableBuilder<CreateApplicationInstanceRequest.Builder, CreateApplicationInstanceRequest> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceIdToReplace")
            .getter(getter(CreateApplicationInstanceRequest::applicationInstanceIdToReplace))
            .setter(setter(Builder::applicationInstanceIdToReplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace")
                    .build()).build();

    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRuntimeContextDevice")
            .getter(getter(CreateApplicationInstanceRequest::defaultRuntimeContextDevice))
            .setter(setter(Builder::defaultRuntimeContextDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApplicationInstanceRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ManifestOverridesPayload> MANIFEST_OVERRIDES_PAYLOAD_FIELD = SdkField
            .<ManifestOverridesPayload> builder(MarshallingType.SDK_POJO).memberName("ManifestOverridesPayload")
            .getter(getter(CreateApplicationInstanceRequest::manifestOverridesPayload))
            .setter(setter(Builder::manifestOverridesPayload)).constructor(ManifestOverridesPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOverridesPayload").build())
            .build();

    private static final SdkField<ManifestPayload> MANIFEST_PAYLOAD_FIELD = SdkField
            .<ManifestPayload> builder(MarshallingType.SDK_POJO).memberName("ManifestPayload")
            .getter(getter(CreateApplicationInstanceRequest::manifestPayload)).setter(setter(Builder::manifestPayload))
            .constructor(ManifestPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPayload").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateApplicationInstanceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeRoleArn").getter(getter(CreateApplicationInstanceRequest::runtimeRoleArn))
            .setter(setter(Builder::runtimeRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeRoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateApplicationInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD, DESCRIPTION_FIELD,
            MANIFEST_OVERRIDES_PAYLOAD_FIELD, MANIFEST_PAYLOAD_FIELD, NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, TAGS_FIELD));

    private final String applicationInstanceIdToReplace;

    private final String defaultRuntimeContextDevice;

    private final String description;

    private final ManifestOverridesPayload manifestOverridesPayload;

    private final ManifestPayload manifestPayload;

    private final String name;

    private final String runtimeRoleArn;

    private final Map<String, String> tags;

    private CreateApplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.description = builder.description;
        this.manifestOverridesPayload = builder.manifestOverridesPayload;
        this.manifestPayload = builder.manifestPayload;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of an application instance to replace with the new instance.
     * </p>
     * 
     * @return The ID of an application instance to replace with the new instance.
     */
    public final String applicationInstanceIdToReplace() {
        return applicationInstanceIdToReplace;
    }

    /**
     * <p>
     * A device's ID.
     * </p>
     * 
     * @return A device's ID.
     */
    public final String defaultRuntimeContextDevice() {
        return defaultRuntimeContextDevice;
    }

    /**
     * <p>
     * A description for the application instance.
     * </p>
     * 
     * @return A description for the application instance.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Setting overrides for the application manifest.
     * </p>
     * 
     * @return Setting overrides for the application manifest.
     */
    public final ManifestOverridesPayload manifestOverridesPayload() {
        return manifestOverridesPayload;
    }

    /**
     * <p>
     * The application's manifest document.
     * </p>
     * 
     * @return The application's manifest document.
     */
    public final ManifestPayload manifestPayload() {
        return manifestPayload;
    }

    /**
     * <p>
     * A name for the application instance.
     * </p>
     * 
     * @return A name for the application instance.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of a runtime role for the application instance.
     * </p>
     * 
     * @return The ARN of a runtime role for the application instance.
     */
    public final String runtimeRoleArn() {
        return runtimeRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the application instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the application instance.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(manifestOverridesPayload());
        hashCode = 31 * hashCode + Objects.hashCode(manifestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationInstanceRequest)) {
            return false;
        }
        CreateApplicationInstanceRequest other = (CreateApplicationInstanceRequest) obj;
        return Objects.equals(applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace())
                && Objects.equals(defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice())
                && Objects.equals(description(), other.description())
                && Objects.equals(manifestOverridesPayload(), other.manifestOverridesPayload())
                && Objects.equals(manifestPayload(), other.manifestPayload()) && Objects.equals(name(), other.name())
                && Objects.equals(runtimeRoleArn(), other.runtimeRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationInstanceRequest")
                .add("ApplicationInstanceIdToReplace", applicationInstanceIdToReplace())
                .add("DefaultRuntimeContextDevice", defaultRuntimeContextDevice()).add("Description", description())
                .add("ManifestOverridesPayload", manifestOverridesPayload()).add("ManifestPayload", manifestPayload())
                .add("Name", name()).add("RuntimeRoleArn", runtimeRoleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInstanceIdToReplace":
            return Optional.ofNullable(clazz.cast(applicationInstanceIdToReplace()));
        case "DefaultRuntimeContextDevice":
            return Optional.ofNullable(clazz.cast(defaultRuntimeContextDevice()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ManifestOverridesPayload":
            return Optional.ofNullable(clazz.cast(manifestOverridesPayload()));
        case "ManifestPayload":
            return Optional.ofNullable(clazz.cast(manifestPayload()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuntimeRoleArn":
            return Optional.ofNullable(clazz.cast(runtimeRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationInstanceRequest, T> g) {
        return obj -> g.apply((CreateApplicationInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationInstanceRequest> {
        /**
         * <p>
         * The ID of an application instance to replace with the new instance.
         * </p>
         * 
         * @param applicationInstanceIdToReplace
         *        The ID of an application instance to replace with the new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace);

        /**
         * <p>
         * A device's ID.
         * </p>
         * 
         * @param defaultRuntimeContextDevice
         *        A device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice);

        /**
         * <p>
         * A description for the application instance.
         * </p>
         * 
         * @param description
         *        A description for the application instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Setting overrides for the application manifest.
         * </p>
         * 
         * @param manifestOverridesPayload
         *        Setting overrides for the application manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload);

        /**
         * <p>
         * Setting overrides for the application manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestOverridesPayload.Builder}
         * avoiding the need to create one manually via {@link ManifestOverridesPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestOverridesPayload.Builder#build()} is called immediately
         * and its result is passed to {@link #manifestOverridesPayload(ManifestOverridesPayload)}.
         * 
         * @param manifestOverridesPayload
         *        a consumer that will call methods on {@link ManifestOverridesPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestOverridesPayload(ManifestOverridesPayload)
         */
        default Builder manifestOverridesPayload(Consumer<ManifestOverridesPayload.Builder> manifestOverridesPayload) {
            return manifestOverridesPayload(ManifestOverridesPayload.builder().applyMutation(manifestOverridesPayload).build());
        }

        /**
         * <p>
         * The application's manifest document.
         * </p>
         * 
         * @param manifestPayload
         *        The application's manifest document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestPayload(ManifestPayload manifestPayload);

        /**
         * <p>
         * The application's manifest document.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestPayload.Builder} avoiding the
         * need to create one manually via {@link ManifestPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #manifestPayload(ManifestPayload)}.
         * 
         * @param manifestPayload
         *        a consumer that will call methods on {@link ManifestPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestPayload(ManifestPayload)
         */
        default Builder manifestPayload(Consumer<ManifestPayload.Builder> manifestPayload) {
            return manifestPayload(ManifestPayload.builder().applyMutation(manifestPayload).build());
        }

        /**
         * <p>
         * A name for the application instance.
         * </p>
         * 
         * @param name
         *        A name for the application instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of a runtime role for the application instance.
         * </p>
         * 
         * @param runtimeRoleArn
         *        The ARN of a runtime role for the application instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRoleArn(String runtimeRoleArn);

        /**
         * <p>
         * Tags for the application instance.
         * </p>
         * 
         * @param tags
         *        Tags for the application instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String applicationInstanceIdToReplace;

        private String defaultRuntimeContextDevice;

        private String description;

        private ManifestOverridesPayload manifestOverridesPayload;

        private ManifestPayload manifestPayload;

        private String name;

        private String runtimeRoleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationInstanceRequest model) {
            super(model);
            applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            description(model.description);
            manifestOverridesPayload(model.manifestOverridesPayload);
            manifestPayload(model.manifestPayload);
            name(model.name);
            runtimeRoleArn(model.runtimeRoleArn);
            tags(model.tags);
        }

        public final String getApplicationInstanceIdToReplace() {
            return applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ManifestOverridesPayload.Builder getManifestOverridesPayload() {
            return manifestOverridesPayload != null ? manifestOverridesPayload.toBuilder() : null;
        }

        public final void setManifestOverridesPayload(ManifestOverridesPayload.BuilderImpl manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload != null ? manifestOverridesPayload.build() : null;
        }

        @Override
        public final Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        public final ManifestPayload.Builder getManifestPayload() {
            return manifestPayload != null ? manifestPayload.toBuilder() : null;
        }

        public final void setManifestPayload(ManifestPayload.BuilderImpl manifestPayload) {
            this.manifestPayload = manifestPayload != null ? manifestPayload.build() : null;
        }

        @Override
        public final Builder manifestPayload(ManifestPayload manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationInstanceRequest build() {
            return new CreateApplicationInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
