/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.panorama.model.AccessDeniedException;
import software.amazon.awssdk.services.panorama.model.ConflictException;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DeletePackageRequest;
import software.amazon.awssdk.services.panorama.model.DeletePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.InternalServerException;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesResponse;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListNodesRequest;
import software.amazon.awssdk.services.panorama.model.ListNodesResponse;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.panorama.model.PanoramaException;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.ResourceNotFoundException;
import software.amazon.awssdk.services.panorama.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.TagResourceRequest;
import software.amazon.awssdk.services.panorama.model.TagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UntagResourceRequest;
import software.amazon.awssdk.services.panorama.model.UntagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse;
import software.amazon.awssdk.services.panorama.model.ValidationException;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListNodesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable;

/**
 * Service client for accessing Panorama. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>AWS Panorama</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is the <i>AWS Panorama API Reference</i>. For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/panorama/latest/dev/panorama-welcome.html">What is AWS Panorama?</a> in the <i>AWS
 * Panorama Developer Guide</i>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PanoramaClient extends AwsClient {
    String SERVICE_NAME = "panorama";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "panorama";

    /**
     * <p>
     * Creates an application instance and deploys it to a device.
     * </p>
     *
     * @param createApplicationInstanceRequest
     * @return Result of the CreateApplicationInstance operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationInstanceResponse createApplicationInstance(
            CreateApplicationInstanceRequest createApplicationInstanceRequest) throws ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application instance and deploys it to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param createApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the CreateApplicationInstance operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationInstanceResponse createApplicationInstance(
            Consumer<CreateApplicationInstanceRequest.Builder> createApplicationInstanceRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return createApplicationInstance(CreateApplicationInstanceRequest.builder()
                .applyMutation(createApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a job to run on a device. A job can update a device's software or reboot it.
     * </p>
     *
     * @param createJobForDevicesRequest
     * @return Result of the CreateJobForDevices operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateJobForDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateJobForDevicesResponse createJobForDevices(CreateJobForDevicesRequest createJobForDevicesRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job to run on a device. A job can update a device's software or reboot it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobForDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateJobForDevicesRequest#builder()}
     * </p>
     *
     * @param createJobForDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the CreateJobForDevices operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateJobForDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateJobForDevicesResponse createJobForDevices(
            Consumer<CreateJobForDevicesRequest.Builder> createJobForDevicesRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return createJobForDevices(CreateJobForDevicesRequest.builder().applyMutation(createJobForDevicesRequest).build());
    }

    /**
     * <p>
     * Creates a camera stream node.
     * </p>
     *
     * @param createNodeFromTemplateJobRequest
     * @return Result of the CreateNodeFromTemplateJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNodeFromTemplateJobResponse createNodeFromTemplateJob(
            CreateNodeFromTemplateJobRequest createNodeFromTemplateJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a camera stream node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeFromTemplateJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateNodeFromTemplateJobRequest#builder()}
     * </p>
     *
     * @param createNodeFromTemplateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest.Builder} to create
     *        a request.
     * @return Result of the CreateNodeFromTemplateJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreateNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNodeFromTemplateJobResponse createNodeFromTemplateJob(
            Consumer<CreateNodeFromTemplateJobRequest.Builder> createNodeFromTemplateJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return createNodeFromTemplateJob(CreateNodeFromTemplateJobRequest.builder()
                .applyMutation(createNodeFromTemplateJobRequest).build());
    }

    /**
     * <p>
     * Creates a package and storage location in an Amazon S3 access point.
     * </p>
     *
     * @param createPackageRequest
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreatePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a package and storage location in an Amazon S3 access point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreatePackageRequest.Builder} to create a request.
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreatePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePackageResponse createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Imports a node package.
     * </p>
     *
     * @param createPackageImportJobRequest
     * @return Result of the CreatePackageImportJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreatePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePackageImportJobResponse createPackageImportJob(CreatePackageImportJobRequest createPackageImportJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a node package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePackageImportJobRequest#builder()}
     * </p>
     *
     * @param createPackageImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePackageImportJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.CreatePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePackageImportJobResponse createPackageImportJob(
            Consumer<CreatePackageImportJobRequest.Builder> createPackageImportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return createPackageImportJob(CreatePackageImportJobRequest.builder().applyMutation(createPackageImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a device.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest.Builder} to create a request.
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes a package.
     * </p>
     * <note>
     * <p>
     * To delete a package, you need permission to call <code>s3:DeleteObject</code> in addition to permissions for the
     * AWS Panorama API.
     * </p>
     * </note>
     *
     * @param deletePackageRequest
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeletePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a package.
     * </p>
     * <note>
     * <p>
     * To delete a package, you need permission to call <code>s3:DeleteObject</code> in addition to permissions for the
     * AWS Panorama API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeletePackageRequest.Builder} to create a request.
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeletePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePackageResponse deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Deregisters a package version.
     * </p>
     *
     * @param deregisterPackageVersionRequest
     * @return Result of the DeregisterPackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeregisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterPackageVersionResponse deregisterPackageVersion(
            DeregisterPackageVersionRequest deregisterPackageVersionRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterPackageVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterPackageVersionRequest#builder()}
     * </p>
     *
     * @param deregisterPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterPackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DeregisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterPackageVersionResponse deregisterPackageVersion(
            Consumer<DeregisterPackageVersionRequest.Builder> deregisterPackageVersionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return deregisterPackageVersion(DeregisterPackageVersionRequest.builder().applyMutation(deregisterPackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an application instance on a device.
     * </p>
     *
     * @param describeApplicationInstanceRequest
     * @return Result of the DescribeApplicationInstance operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationInstanceResponse describeApplicationInstance(
            DescribeApplicationInstanceRequest describeApplicationInstanceRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an application instance on a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param describeApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeApplicationInstance operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationInstanceResponse describeApplicationInstance(
            Consumer<DescribeApplicationInstanceRequest.Builder> describeApplicationInstanceRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return describeApplicationInstance(DescribeApplicationInstanceRequest.builder()
                .applyMutation(describeApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Returns information about an application instance's configuration manifest.
     * </p>
     *
     * @param describeApplicationInstanceDetailsRequest
     * @return Result of the DescribeApplicationInstanceDetails operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeApplicationInstanceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetails(
            DescribeApplicationInstanceDetailsRequest describeApplicationInstanceDetailsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an application instance's configuration manifest.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationInstanceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationInstanceDetailsRequest#builder()}
     * </p>
     *
     * @param describeApplicationInstanceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeApplicationInstanceDetails operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeApplicationInstanceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetails(
            Consumer<DescribeApplicationInstanceDetailsRequest.Builder> describeApplicationInstanceDetailsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return describeApplicationInstanceDetails(DescribeApplicationInstanceDetailsRequest.builder()
                .applyMutation(describeApplicationInstanceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns information about a device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest.Builder} to create a request.
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, PanoramaException {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Returns information about a device job.
     * </p>
     *
     * @param describeDeviceJobRequest
     * @return Result of the DescribeDeviceJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeDeviceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeviceJobResponse describeDeviceJob(DescribeDeviceJobRequest describeDeviceJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDeviceJobRequest#builder()}
     * </p>
     *
     * @param describeDeviceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDeviceJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeDeviceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeviceJobResponse describeDeviceJob(Consumer<DescribeDeviceJobRequest.Builder> describeDeviceJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return describeDeviceJob(DescribeDeviceJobRequest.builder().applyMutation(describeDeviceJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a node.
     * </p>
     *
     * @param describeNodeRequest
     * @return Result of the DescribeNode operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeNodeRequest#builder()}
     * </p>
     *
     * @param describeNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeNodeRequest.Builder} to create a request.
     * @return Result of the DescribeNode operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodeResponse describeNode(Consumer<DescribeNodeRequest.Builder> describeNodeRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return describeNode(DescribeNodeRequest.builder().applyMutation(describeNodeRequest).build());
    }

    /**
     * <p>
     * Returns information about a job to create a camera stream node.
     * </p>
     *
     * @param describeNodeFromTemplateJobRequest
     * @return Result of the DescribeNodeFromTemplateJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJob(
            DescribeNodeFromTemplateJobRequest describeNodeFromTemplateJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a job to create a camera stream node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeFromTemplateJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNodeFromTemplateJobRequest#builder()}
     * </p>
     *
     * @param describeNodeFromTemplateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeNodeFromTemplateJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribeNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJob(
            Consumer<DescribeNodeFromTemplateJobRequest.Builder> describeNodeFromTemplateJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return describeNodeFromTemplateJob(DescribeNodeFromTemplateJobRequest.builder()
                .applyMutation(describeNodeFromTemplateJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a package.
     * </p>
     *
     * @param describePackageRequest
     * @return Result of the DescribePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePackageResponse describePackage(DescribePackageRequest describePackageRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackageRequest#builder()}
     * </p>
     *
     * @param describePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageRequest.Builder} to create a request.
     * @return Result of the DescribePackage operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePackageResponse describePackage(Consumer<DescribePackageRequest.Builder> describePackageRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return describePackage(DescribePackageRequest.builder().applyMutation(describePackageRequest).build());
    }

    /**
     * <p>
     * Returns information about a package import job.
     * </p>
     *
     * @param describePackageImportJobRequest
     * @return Result of the DescribePackageImportJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePackageImportJobResponse describePackageImportJob(
            DescribePackageImportJobRequest describePackageImportJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePackageImportJobRequest#builder()}
     * </p>
     *
     * @param describePackageImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePackageImportJob operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePackageImportJobResponse describePackageImportJob(
            Consumer<DescribePackageImportJobRequest.Builder> describePackageImportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return describePackageImportJob(DescribePackageImportJobRequest.builder().applyMutation(describePackageImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a package version.
     * </p>
     *
     * @param describePackageVersionRequest
     * @return Result of the DescribePackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePackageVersionResponse describePackageVersion(DescribePackageVersionRequest describePackageVersionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePackageVersionRequest#builder()}
     * </p>
     *
     * @param describePackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePackageVersionResponse describePackageVersion(
            Consumer<DescribePackageVersionRequest.Builder> describePackageVersionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return describePackageVersion(DescribePackageVersionRequest.builder().applyMutation(describePackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     * @return Result of the ListApplicationInstanceDependencies operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesResponse listApplicationInstanceDependencies(
            ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstanceDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationInstanceDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationInstanceDependencies operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesResponse listApplicationInstanceDependencies(
            Consumer<ListApplicationInstanceDependenciesRequest.Builder> listApplicationInstanceDependenciesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstanceDependencies(ListApplicationInstanceDependenciesRequest.builder()
                .applyMutation(listApplicationInstanceDependenciesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client.listApplicationInstanceDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client
     *             .listApplicationInstanceDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client.listApplicationInstanceDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesIterable listApplicationInstanceDependenciesPaginator(
            ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstanceDependenciesIterable(this, listApplicationInstanceDependenciesRequest);
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client.listApplicationInstanceDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client
     *             .listApplicationInstanceDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable responses = client.listApplicationInstanceDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstanceDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationInstanceDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesIterable listApplicationInstanceDependenciesPaginator(
            Consumer<ListApplicationInstanceDependenciesRequest.Builder> listApplicationInstanceDependenciesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstanceDependenciesPaginator(ListApplicationInstanceDependenciesRequest.builder()
                .applyMutation(listApplicationInstanceDependenciesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     * @return Result of the ListApplicationInstanceNodeInstances operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstances(
            ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationInstanceNodeInstances operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstances(
            Consumer<ListApplicationInstanceNodeInstancesRequest.Builder> listApplicationInstanceNodeInstancesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(listApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client.listApplicationInstanceNodeInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client
     *             .listApplicationInstanceNodeInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client.listApplicationInstanceNodeInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesIterable listApplicationInstanceNodeInstancesPaginator(
            ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstanceNodeInstancesIterable(this, listApplicationInstanceNodeInstancesRequest);
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client.listApplicationInstanceNodeInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client
     *             .listApplicationInstanceNodeInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable responses = client.listApplicationInstanceNodeInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesIterable listApplicationInstanceNodeInstancesPaginator(
            Consumer<ListApplicationInstanceNodeInstancesRequest.Builder> listApplicationInstanceNodeInstancesRequest)
            throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstanceNodeInstancesPaginator(ListApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(listApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     *
     * @param listApplicationInstancesRequest
     * @return Result of the ListApplicationInstances operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesResponse listApplicationInstances(
            ListApplicationInstancesRequest listApplicationInstancesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListApplicationInstances operation returned by the service.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesResponse listApplicationInstances(
            Consumer<ListApplicationInstancesRequest.Builder> listApplicationInstancesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstances(ListApplicationInstancesRequest.builder().applyMutation(listApplicationInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client.listApplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client
     *             .listApplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client.listApplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesIterable listApplicationInstancesPaginator(
            ListApplicationInstancesRequest listApplicationInstancesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstancesIterable(this, listApplicationInstancesRequest);
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client.listApplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client
     *             .listApplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable responses = client.listApplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesIterable listApplicationInstancesPaginator(
            Consumer<ListApplicationInstancesRequest.Builder> listApplicationInstancesRequest) throws AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listApplicationInstancesPaginator(ListApplicationInstancesRequest.builder()
                .applyMutation(listApplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     *
     * @param listDevicesRequest
     * @return Result of the ListDevices operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesRequest.Builder} to create a request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return new ListDevicesIterable(this, listDevicesRequest);
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     *
     * @param listDevicesJobsRequest
     * @return Result of the ListDevicesJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsResponse listDevicesJobs(ListDevicesJobsRequest listDevicesJobsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicesJobsRequest#builder()}
     * </p>
     *
     * @param listDevicesJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest.Builder} to create a request.
     * @return Result of the ListDevicesJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsResponse listDevicesJobs(Consumer<ListDevicesJobsRequest.Builder> listDevicesJobsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listDevicesJobs(ListDevicesJobsRequest.builder().applyMutation(listDevicesJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client.listDevicesJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client
     *             .listDevicesJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client.listDevicesJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsIterable listDevicesJobsPaginator(ListDevicesJobsRequest listDevicesJobsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListDevicesJobsIterable(this, listDevicesJobsRequest);
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client.listDevicesJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client
     *             .listDevicesJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable responses = client.listDevicesJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicesJobsRequest#builder()}
     * </p>
     *
     * @param listDevicesJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsIterable listDevicesJobsPaginator(Consumer<ListDevicesJobsRequest.Builder> listDevicesJobsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listDevicesJobsPaginator(ListDevicesJobsRequest.builder().applyMutation(listDevicesJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     * @return Result of the ListNodeFromTemplateJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsResponse listNodeFromTemplateJobs(
            ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodeFromTemplateJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNodeFromTemplateJobsRequest#builder()}
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListNodeFromTemplateJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsResponse listNodeFromTemplateJobs(
            Consumer<ListNodeFromTemplateJobsRequest.Builder> listNodeFromTemplateJobsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return listNodeFromTemplateJobs(ListNodeFromTemplateJobsRequest.builder().applyMutation(listNodeFromTemplateJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client.listNodeFromTemplateJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client
     *             .listNodeFromTemplateJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client.listNodeFromTemplateJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsIterable listNodeFromTemplateJobsPaginator(
            ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) throws ConflictException, ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListNodeFromTemplateJobsIterable(this, listNodeFromTemplateJobsRequest);
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client.listNodeFromTemplateJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client
     *             .listNodeFromTemplateJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable responses = client.listNodeFromTemplateJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodeFromTemplateJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNodeFromTemplateJobsRequest#builder()}
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsIterable listNodeFromTemplateJobsPaginator(
            Consumer<ListNodeFromTemplateJobsRequest.Builder> listNodeFromTemplateJobsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return listNodeFromTemplateJobsPaginator(ListNodeFromTemplateJobsRequest.builder()
                .applyMutation(listNodeFromTemplateJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     *
     * @param listNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws ConflictException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodesRequest.Builder} to create a request.
     * @return Result of the ListNodes operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) throws ConflictException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws ConflictException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListNodesIterable(this, listNodesRequest);
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) throws ConflictException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     *
     * @param listPackageImportJobsRequest
     * @return Result of the ListPackageImportJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsResponse listPackageImportJobs(ListPackageImportJobsRequest listPackageImportJobsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageImportJobsRequest#builder()}
     * </p>
     *
     * @param listPackageImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPackageImportJobs operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsResponse listPackageImportJobs(
            Consumer<ListPackageImportJobsRequest.Builder> listPackageImportJobsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return listPackageImportJobs(ListPackageImportJobsRequest.builder().applyMutation(listPackageImportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client.listPackageImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client
     *             .listPackageImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client.listPackageImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackageImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsIterable listPackageImportJobsPaginator(ListPackageImportJobsRequest listPackageImportJobsRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return new ListPackageImportJobsIterable(this, listPackageImportJobsRequest);
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client.listPackageImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client
     *             .listPackageImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable responses = client.listPackageImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageImportJobsRequest#builder()}
     * </p>
     *
     * @param listPackageImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsIterable listPackageImportJobsPaginator(
            Consumer<ListPackageImportJobsRequest.Builder> listPackageImportJobsRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return listPackageImportJobsPaginator(ListPackageImportJobsRequest.builder().applyMutation(listPackageImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     *
     * @param listPackagesRequest
     * @return Result of the ListPackages operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesResponse listPackages(ListPackagesRequest listPackagesRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackagesRequest.Builder} to create a request.
     * @return Result of the ListPackages operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesResponse listPackages(Consumer<ListPackagesRequest.Builder> listPackagesRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listPackages(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)} operation.</b>
     * </p>
     *
     * @param listPackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesIterable listPackagesPaginator(ListPackagesRequest listPackagesRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return new ListPackagesIterable(this, listPackagesRequest);
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.panorama.model.ListPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable responses = client.listPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesIterable listPackagesPaginator(Consumer<ListPackagesRequest.Builder> listPackagesRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listPackagesPaginator(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a
     * provisioning certificate that is valid for 5 minutes. Name the configuration archive
     * <code>certificates-omni_<i>device-name</i>.zip</code> and transfer it to the device within 5 minutes. Use the
     * included USB storage device and connect it to the USB 3.0 port next to the HDMI output.
     * </p>
     *
     * @param provisionDeviceRequest
     * @return Result of the ProvisionDevice operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ProvisionDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ProvisionDeviceResponse provisionDevice(ProvisionDeviceRequest provisionDeviceRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a
     * provisioning certificate that is valid for 5 minutes. Name the configuration archive
     * <code>certificates-omni_<i>device-name</i>.zip</code> and transfer it to the device within 5 minutes. Use the
     * included USB storage device and connect it to the USB 3.0 port next to the HDMI output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link ProvisionDeviceRequest#builder()}
     * </p>
     *
     * @param provisionDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest.Builder} to create a request.
     * @return Result of the ProvisionDevice operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.ProvisionDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ProvisionDeviceResponse provisionDevice(Consumer<ProvisionDeviceRequest.Builder> provisionDeviceRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return provisionDevice(ProvisionDeviceRequest.builder().applyMutation(provisionDeviceRequest).build());
    }

    /**
     * <p>
     * Registers a package version.
     * </p>
     *
     * @param registerPackageVersionRequest
     * @return Result of the RegisterPackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.RegisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterPackageVersionResponse registerPackageVersion(RegisterPackageVersionRequest registerPackageVersionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterPackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterPackageVersionRequest#builder()}
     * </p>
     *
     * @param registerPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterPackageVersion operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.RegisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterPackageVersionResponse registerPackageVersion(
            Consumer<RegisterPackageVersionRequest.Builder> registerPackageVersionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        return registerPackageVersion(RegisterPackageVersionRequest.builder().applyMutation(registerPackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Removes an application instance.
     * </p>
     *
     * @param removeApplicationInstanceRequest
     * @return Result of the RemoveApplicationInstance operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.RemoveApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveApplicationInstanceResponse removeApplicationInstance(
            RemoveApplicationInstanceRequest removeApplicationInstanceRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an application instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveApplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param removeApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveApplicationInstance operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.RemoveApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveApplicationInstanceResponse removeApplicationInstance(
            Consumer<RemoveApplicationInstanceRequest.Builder> removeApplicationInstanceRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return removeApplicationInstance(RemoveApplicationInstanceRequest.builder()
                .applyMutation(removeApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Signal camera nodes to stop or resume.
     * </p>
     *
     * @param signalApplicationInstanceNodeInstancesRequest
     * @return Result of the SignalApplicationInstanceNodeInstances operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.SignalApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/SignalApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SignalApplicationInstanceNodeInstancesResponse signalApplicationInstanceNodeInstances(
            SignalApplicationInstanceNodeInstancesRequest signalApplicationInstanceNodeInstancesRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signal camera nodes to stop or resume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SignalApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link SignalApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param signalApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return Result of the SignalApplicationInstanceNodeInstances operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ServiceQuotaExceededException
     *         The request would cause a limit to be exceeded.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.SignalApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/SignalApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SignalApplicationInstanceNodeInstancesResponse signalApplicationInstanceNodeInstances(
            Consumer<SignalApplicationInstanceNodeInstancesRequest.Builder> signalApplicationInstanceNodeInstancesRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, PanoramaException {
        return signalApplicationInstanceNodeInstances(SignalApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(signalApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a device's metadata.
     * </p>
     *
     * @param updateDeviceMetadataRequest
     * @return Result of the UpdateDeviceMetadata operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.UpdateDeviceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceMetadataResponse updateDeviceMetadata(UpdateDeviceMetadataRequest updateDeviceMetadataRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a device's metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceMetadataRequest#builder()}
     * </p>
     *
     * @param updateDeviceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDeviceMetadata operation returned by the service.
     * @throws ConflictException
     *         The target resource is in use.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         The requestor does not have permission to access the target action or resource.
     * @throws ResourceNotFoundException
     *         The target resource was not found.
     * @throws InternalServerException
     *         An internal error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PanoramaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PanoramaClient.UpdateDeviceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceMetadataResponse updateDeviceMetadata(
            Consumer<UpdateDeviceMetadataRequest.Builder> updateDeviceMetadataRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, PanoramaException {
        return updateDeviceMetadata(UpdateDeviceMetadataRequest.builder().applyMutation(updateDeviceMetadataRequest).build());
    }

    /**
     * Create a {@link PanoramaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PanoramaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PanoramaClient}.
     */
    static PanoramaClientBuilder builder() {
        return new DefaultPanoramaClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PanoramaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
