/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;

public class ListApplicationInstanceNodeInstancesPublisher
implements SdkPublisher<ListApplicationInstanceNodeInstancesResponse> {
    private final PanoramaAsyncClient client;
    private final ListApplicationInstanceNodeInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationInstanceNodeInstancesPublisher(PanoramaAsyncClient client, ListApplicationInstanceNodeInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationInstanceNodeInstancesPublisher(PanoramaAsyncClient client, ListApplicationInstanceNodeInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationInstanceNodeInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationInstanceNodeInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationInstanceNodeInstancesResponseFetcher
    implements AsyncPageFetcher<ListApplicationInstanceNodeInstancesResponse> {
        private ListApplicationInstanceNodeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstanceNodeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationInstanceNodeInstancesResponse> nextPage(ListApplicationInstanceNodeInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstanceNodeInstancesPublisher.this.client.listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesPublisher.this.firstRequest);
            }
            return ListApplicationInstanceNodeInstancesPublisher.this.client.listApplicationInstanceNodeInstances((ListApplicationInstanceNodeInstancesRequest)((Object)ListApplicationInstanceNodeInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

