/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceConnectionStatus {
    ONLINE("ONLINE"),
    OFFLINE("OFFLINE"),
    AWAITING_CREDENTIALS("AWAITING_CREDENTIALS"),
    NOT_AVAILABLE("NOT_AVAILABLE"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceConnectionStatus> VALUE_MAP;
    private final String value;

    private DeviceConnectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceConnectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceConnectionStatus> knownValues() {
        EnumSet<DeviceConnectionStatus> knownValues = EnumSet.allOf(DeviceConnectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceConnectionStatus.class, DeviceConnectionStatus::toString);
    }
}

