/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceReportedStatus {
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    STOP_ERROR("STOP_ERROR"),
    REMOVAL_FAILED("REMOVAL_FAILED"),
    REMOVAL_IN_PROGRESS("REMOVAL_IN_PROGRESS"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    INSTALL_ERROR("INSTALL_ERROR"),
    LAUNCHED("LAUNCHED"),
    LAUNCH_ERROR("LAUNCH_ERROR"),
    INSTALL_IN_PROGRESS("INSTALL_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceReportedStatus> VALUE_MAP;
    private final String value;

    private DeviceReportedStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceReportedStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceReportedStatus> knownValues() {
        EnumSet<DeviceReportedStatus> knownValues = EnumSet.allOf(DeviceReportedStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceReportedStatus.class, DeviceReportedStatus::toString);
    }
}

