/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSiteRequest extends OutpostsRequest implements
        ToCopyableBuilder<CreateSiteRequest.Builder, CreateSiteRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSiteRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSiteRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(CreateSiteRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSiteRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Address> OPERATING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("OperatingAddress").getter(getter(CreateSiteRequest::operatingAddress))
            .setter(setter(Builder::operatingAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddress").build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("ShippingAddress").getter(getter(CreateSiteRequest::shippingAddress))
            .setter(setter(Builder::shippingAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()).build();

    private static final SdkField<RackPhysicalProperties> RACK_PHYSICAL_PROPERTIES_FIELD = SdkField
            .<RackPhysicalProperties> builder(MarshallingType.SDK_POJO).memberName("RackPhysicalProperties")
            .getter(getter(CreateSiteRequest::rackPhysicalProperties)).setter(setter(Builder::rackPhysicalProperties))
            .constructor(RackPhysicalProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackPhysicalProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            NOTES_FIELD, TAGS_FIELD, OPERATING_ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, RACK_PHYSICAL_PROPERTIES_FIELD));

    private final String name;

    private final String description;

    private final String notes;

    private final Map<String, String> tags;

    private final Address operatingAddress;

    private final Address shippingAddress;

    private final RackPhysicalProperties rackPhysicalProperties;

    private CreateSiteRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.notes = builder.notes;
        this.tags = builder.tags;
        this.operatingAddress = builder.operatingAddress;
        this.shippingAddress = builder.shippingAddress;
        this.rackPhysicalProperties = builder.rackPhysicalProperties;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Additional information that you provide about site access requirements, electrician scheduling, personal
     * protective equipment, or regulation of equipment materials that could affect your installation process.
     * </p>
     * 
     * @return Additional information that you provide about site access requirements, electrician scheduling, personal
     *         protective equipment, or regulation of equipment materials that could affect your installation process.
     */
    public final String notes() {
        return notes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to a site.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to a site.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The location to install and power on the hardware. This address might be different from the shipping address.
     * </p>
     * 
     * @return The location to install and power on the hardware. This address might be different from the shipping
     *         address.
     */
    public final Address operatingAddress() {
        return operatingAddress;
    }

    /**
     * <p>
     * The location to ship the hardware. This address might be different from the operating address.
     * </p>
     * 
     * @return The location to ship the hardware. This address might be different from the operating address.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * Information about the physical and logistical details for the rack at this site. For more information about
     * hardware requirements for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * 
     * @return Information about the physical and logistical details for the rack at this site. For more information
     *         about hardware requirements for racks, see <a
     *         href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     *         readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     */
    public final RackPhysicalProperties rackPhysicalProperties() {
        return rackPhysicalProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(rackPhysicalProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSiteRequest)) {
            return false;
        }
        CreateSiteRequest other = (CreateSiteRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(notes(), other.notes()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(operatingAddress(), other.operatingAddress())
                && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(rackPhysicalProperties(), other.rackPhysicalProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSiteRequest").add("Name", name()).add("Description", description()).add("Notes", notes())
                .add("Tags", hasTags() ? tags() : null).add("OperatingAddress", operatingAddress())
                .add("ShippingAddress", shippingAddress()).add("RackPhysicalProperties", rackPhysicalProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "OperatingAddress":
            return Optional.ofNullable(clazz.cast(operatingAddress()));
        case "ShippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "RackPhysicalProperties":
            return Optional.ofNullable(clazz.cast(rackPhysicalProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSiteRequest, T> g) {
        return obj -> g.apply((CreateSiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSiteRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Additional information that you provide about site access requirements, electrician scheduling, personal
         * protective equipment, or regulation of equipment materials that could affect your installation process.
         * </p>
         * 
         * @param notes
         *        Additional information that you provide about site access requirements, electrician scheduling,
         *        personal protective equipment, or regulation of equipment materials that could affect your
         *        installation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * The tags to apply to a site.
         * </p>
         * 
         * @param tags
         *        The tags to apply to a site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The location to install and power on the hardware. This address might be different from the shipping address.
         * </p>
         * 
         * @param operatingAddress
         *        The location to install and power on the hardware. This address might be different from the shipping
         *        address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddress(Address operatingAddress);

        /**
         * <p>
         * The location to install and power on the hardware. This address might be different from the shipping address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #operatingAddress(Address)}.
         * 
         * @param operatingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingAddress(Address)
         */
        default Builder operatingAddress(Consumer<Address.Builder> operatingAddress) {
            return operatingAddress(Address.builder().applyMutation(operatingAddress).build());
        }

        /**
         * <p>
         * The location to ship the hardware. This address might be different from the operating address.
         * </p>
         * 
         * @param shippingAddress
         *        The location to ship the hardware. This address might be different from the operating address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The location to ship the hardware. This address might be different from the operating address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * Information about the physical and logistical details for the rack at this site. For more information about
         * hardware requirements for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
         * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * 
         * @param rackPhysicalProperties
         *        Information about the physical and logistical details for the rack at this site. For more information
         *        about hardware requirements for racks, see <a
         *        href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist"
         *        >Network readiness checklist</a> in the Amazon Web Services Outposts User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties);

        /**
         * <p>
         * Information about the physical and logistical details for the rack at this site. For more information about
         * hardware requirements for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
         * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link RackPhysicalProperties.Builder} avoiding
         * the need to create one manually via {@link RackPhysicalProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RackPhysicalProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #rackPhysicalProperties(RackPhysicalProperties)}.
         * 
         * @param rackPhysicalProperties
         *        a consumer that will call methods on {@link RackPhysicalProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rackPhysicalProperties(RackPhysicalProperties)
         */
        default Builder rackPhysicalProperties(Consumer<RackPhysicalProperties.Builder> rackPhysicalProperties) {
            return rackPhysicalProperties(RackPhysicalProperties.builder().applyMutation(rackPhysicalProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String notes;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Address operatingAddress;

        private Address shippingAddress;

        private RackPhysicalProperties rackPhysicalProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSiteRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            notes(model.notes);
            tags(model.tags);
            operatingAddress(model.operatingAddress);
            shippingAddress(model.shippingAddress);
            rackPhysicalProperties(model.rackPhysicalProperties);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Address.Builder getOperatingAddress() {
            return operatingAddress != null ? operatingAddress.toBuilder() : null;
        }

        public final void setOperatingAddress(Address.BuilderImpl operatingAddress) {
            this.operatingAddress = operatingAddress != null ? operatingAddress.build() : null;
        }

        @Override
        public final Builder operatingAddress(Address operatingAddress) {
            this.operatingAddress = operatingAddress;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final RackPhysicalProperties.Builder getRackPhysicalProperties() {
            return rackPhysicalProperties != null ? rackPhysicalProperties.toBuilder() : null;
        }

        public final void setRackPhysicalProperties(RackPhysicalProperties.BuilderImpl rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties != null ? rackPhysicalProperties.build() : null;
        }

        @Override
        public final Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSiteRequest build() {
            return new CreateSiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
