/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConnectionResponse extends OutpostsResponse implements
        ToCopyableBuilder<StartConnectionResponse.Builder, StartConnectionResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(StartConnectionResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()).build();

    private static final SdkField<String> UNDERLAY_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnderlayIpAddress").getter(getter(StartConnectionResponse::underlayIpAddress))
            .setter(setter(Builder::underlayIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnderlayIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            UNDERLAY_IP_ADDRESS_FIELD));

    private final String connectionId;

    private final String underlayIpAddress;

    private StartConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.underlayIpAddress = builder.underlayIpAddress;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The underlay IP address.
     * </p>
     * 
     * @return The underlay IP address.
     */
    public final String underlayIpAddress() {
        return underlayIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(underlayIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConnectionResponse)) {
            return false;
        }
        StartConnectionResponse other = (StartConnectionResponse) obj;
        return Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(underlayIpAddress(), other.underlayIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConnectionResponse").add("ConnectionId", connectionId())
                .add("UnderlayIpAddress", underlayIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "UnderlayIpAddress":
            return Optional.ofNullable(clazz.cast(underlayIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConnectionResponse, T> g) {
        return obj -> g.apply((StartConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartConnectionResponse> {
        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The underlay IP address.
         * </p>
         * 
         * @param underlayIpAddress
         *        The underlay IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder underlayIpAddress(String underlayIpAddress);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private String connectionId;

        private String underlayIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConnectionResponse model) {
            super(model);
            connectionId(model.connectionId);
            underlayIpAddress(model.underlayIpAddress);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getUnderlayIpAddress() {
            return underlayIpAddress;
        }

        public final void setUnderlayIpAddress(String underlayIpAddress) {
            this.underlayIpAddress = underlayIpAddress;
        }

        @Override
        public final Builder underlayIpAddress(String underlayIpAddress) {
            this.underlayIpAddress = underlayIpAddress;
            return this;
        }

        @Override
        public StartConnectionResponse build() {
            return new StartConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
