/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OpticalStandard {
    OPTIC_10_GBASE_SR("OPTIC_10GBASE_SR"),

    OPTIC_10_GBASE_IR("OPTIC_10GBASE_IR"),

    OPTIC_10_GBASE_LR("OPTIC_10GBASE_LR"),

    OPTIC_40_GBASE_SR("OPTIC_40GBASE_SR"),

    OPTIC_40_GBASE_ESR("OPTIC_40GBASE_ESR"),

    OPTIC_40_GBASE_IR4_LR4_L("OPTIC_40GBASE_IR4_LR4L"),

    OPTIC_40_GBASE_LR4("OPTIC_40GBASE_LR4"),

    OPTIC_100_GBASE_SR4("OPTIC_100GBASE_SR4"),

    OPTIC_100_GBASE_CWDM4("OPTIC_100GBASE_CWDM4"),

    OPTIC_100_GBASE_LR4("OPTIC_100GBASE_LR4"),

    OPTIC_100_G_PSM4_MSA("OPTIC_100G_PSM4_MSA"),

    OPTIC_1000_BASE_LX("OPTIC_1000BASE_LX"),

    OPTIC_1000_BASE_SX("OPTIC_1000BASE_SX"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpticalStandard> VALUE_MAP = EnumUtils.uniqueIndex(OpticalStandard.class,
            OpticalStandard::toString);

    private final String value;

    private OpticalStandard(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OpticalStandard corresponding to the value
     */
    public static OpticalStandard fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OpticalStandard}s
     */
    public static Set<OpticalStandard> knownValues() {
        Set<OpticalStandard> knownValues = EnumSet.allOf(OpticalStandard.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
