/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.AssetType;
import software.amazon.awssdk.services.outposts.model.ComputeAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetInfo> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetId").getter(AssetInfo.getter(AssetInfo::assetId)).setter(AssetInfo.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()}).build();
    private static final SdkField<String> RACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RackId").getter(AssetInfo.getter(AssetInfo::rackId)).setter(AssetInfo.setter(Builder::rackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackId").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetType").getter(AssetInfo.getter(AssetInfo::assetTypeAsString)).setter(AssetInfo.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()}).build();
    private static final SdkField<ComputeAttributes> COMPUTE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeAttributes").getter(AssetInfo.getter(AssetInfo::computeAttributes)).setter(AssetInfo.setter(Builder::computeAttributes)).constructor(ComputeAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, RACK_ID_FIELD, ASSET_TYPE_FIELD, COMPUTE_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String rackId;
    private final String assetType;
    private final ComputeAttributes computeAttributes;

    private AssetInfo(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.rackId = builder.rackId;
        this.assetType = builder.assetType;
        this.computeAttributes = builder.computeAttributes;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String rackId() {
        return this.rackId;
    }

    public final AssetType assetType() {
        return AssetType.fromValue(this.assetType);
    }

    public final String assetTypeAsString() {
        return this.assetType;
    }

    public final ComputeAttributes computeAttributes() {
        return this.computeAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetInfo)) {
            return false;
        }
        AssetInfo other = (AssetInfo)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.rackId(), other.rackId()) && Objects.equals(this.assetTypeAsString(), other.assetTypeAsString()) && Objects.equals(this.computeAttributes(), other.computeAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AssetInfo").add("AssetId", (Object)this.assetId()).add("RackId", (Object)this.rackId()).add("AssetType", (Object)this.assetTypeAsString()).add("ComputeAttributes", (Object)this.computeAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "RackId": {
                return Optional.ofNullable(clazz.cast(this.rackId()));
            }
            case "AssetType": {
                return Optional.ofNullable(clazz.cast(this.assetTypeAsString()));
            }
            case "ComputeAttributes": {
                return Optional.ofNullable(clazz.cast(this.computeAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetInfo, T> g) {
        return obj -> g.apply((AssetInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String rackId;
        private String assetType;
        private ComputeAttributes computeAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetInfo model) {
            this.assetId(model.assetId);
            this.rackId(model.rackId);
            this.assetType(model.assetType);
            this.computeAttributes(model.computeAttributes);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getRackId() {
            return this.rackId;
        }

        public final void setRackId(String rackId) {
            this.rackId = rackId;
        }

        @Override
        public final Builder rackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public final String getAssetType() {
            return this.assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final ComputeAttributes.Builder getComputeAttributes() {
            return this.computeAttributes != null ? this.computeAttributes.toBuilder() : null;
        }

        public final void setComputeAttributes(ComputeAttributes.BuilderImpl computeAttributes) {
            this.computeAttributes = computeAttributes != null ? computeAttributes.build() : null;
        }

        @Override
        public final Builder computeAttributes(ComputeAttributes computeAttributes) {
            this.computeAttributes = computeAttributes;
            return this;
        }

        public AssetInfo build() {
            return new AssetInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetInfo> {
        public Builder assetId(String var1);

        public Builder rackId(String var1);

        public Builder assetType(String var1);

        public Builder assetType(AssetType var1);

        public Builder computeAttributes(ComputeAttributes var1);

        default public Builder computeAttributes(Consumer<ComputeAttributes.Builder> computeAttributes) {
            return this.computeAttributes((ComputeAttributes)((ComputeAttributes.Builder)ComputeAttributes.builder().applyMutation(computeAttributes)).build());
        }
    }
}

