/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for an OpenSearch Ingestion pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineSummary implements SdkPojo, Serializable, ToCopyableBuilder<PipelineSummary.Builder, PipelineSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PipelineSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<PipelineStatusReason> STATUS_REASON_FIELD = SdkField
            .<PipelineStatusReason> builder(MarshallingType.SDK_POJO).memberName("StatusReason")
            .getter(getter(PipelineSummary::statusReason)).setter(setter(Builder::statusReason))
            .constructor(PipelineStatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(PipelineSummary::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineSummary::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<Integer> MIN_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinUnits").getter(getter(PipelineSummary::minUnits)).setter(setter(Builder::minUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUnits").build()).build();

    private static final SdkField<Integer> MAX_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxUnits").getter(getter(PipelineSummary::maxUnits)).setter(setter(Builder::maxUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUnits").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PipelineSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(PipelineSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, PIPELINE_NAME_FIELD, PIPELINE_ARN_FIELD, MIN_UNITS_FIELD, MAX_UNITS_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final PipelineStatusReason statusReason;

    private final String pipelineName;

    private final String pipelineArn;

    private final Integer minUnits;

    private final Integer maxUnits;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private PipelineSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.pipelineName = builder.pipelineName;
        this.pipelineArn = builder.pipelineArn;
        this.minUnits = builder.minUnits;
        this.maxUnits = builder.maxUnits;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The current status of the pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline.
     * @see PipelineStatus
     */
    public final PipelineStatus status() {
        return PipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline.
     * @see PipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusReason property for this object.
     * 
     * @return The value of the StatusReason property for this object.
     */
    public final PipelineStatusReason statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     * </p>
     * 
     * @return The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    public final Integer minUnits() {
        return minUnits;
    }

    /**
     * <p>
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     * </p>
     * 
     * @return The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    public final Integer maxUnits() {
        return maxUnits;
    }

    /**
     * <p>
     * The date and time when the pipeline was created.
     * </p>
     * 
     * @return The date and time when the pipeline was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the pipeline was last updated.
     * </p>
     * 
     * @return The date and time when the pipeline was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(minUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maxUnits());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(minUnits(), other.minUnits()) && Objects.equals(maxUnits(), other.maxUnits())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineSummary").add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("PipelineName", pipelineName()).add("PipelineArn", pipelineArn()).add("MinUnits", minUnits())
                .add("MaxUnits", maxUnits()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "MinUnits":
            return Optional.ofNullable(clazz.cast(minUnits()));
        case "MaxUnits":
            return Optional.ofNullable(clazz.cast(maxUnits()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineSummary> {
        /**
         * <p>
         * The current status of the pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(PipelineStatus status);

        /**
         * Sets the value of the StatusReason property for this object.
         *
         * @param statusReason
         *        The new value for the StatusReason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(PipelineStatusReason statusReason);

        /**
         * Sets the value of the StatusReason property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PipelineStatusReason.Builder} avoiding
         * the need to create one manually via {@link PipelineStatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineStatusReason.Builder#build()} is called immediately and
         * its result is passed to {@link #statusReason(PipelineStatusReason)}.
         * 
         * @param statusReason
         *        a consumer that will call methods on {@link PipelineStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReason(PipelineStatusReason)
         */
        default Builder statusReason(Consumer<PipelineStatusReason.Builder> statusReason) {
            return statusReason(PipelineStatusReason.builder().applyMutation(statusReason).build());
        }

        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
         * </p>
         * 
         * @param minUnits
         *        The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUnits(Integer minUnits);

        /**
         * <p>
         * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
         * </p>
         * 
         * @param maxUnits
         *        The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnits(Integer maxUnits);

        /**
         * <p>
         * The date and time when the pipeline was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the pipeline was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when the pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private PipelineStatusReason statusReason;

        private String pipelineName;

        private String pipelineArn;

        private Integer minUnits;

        private Integer maxUnits;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            status(model.status);
            statusReason(model.statusReason);
            pipelineName(model.pipelineName);
            pipelineArn(model.pipelineArn);
            minUnits(model.minUnits);
            maxUnits(model.maxUnits);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final PipelineStatusReason.Builder getStatusReason() {
            return statusReason != null ? statusReason.toBuilder() : null;
        }

        public final void setStatusReason(PipelineStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(PipelineStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Integer getMinUnits() {
            return minUnits;
        }

        public final void setMinUnits(Integer minUnits) {
            this.minUnits = minUnits;
        }

        @Override
        public final Builder minUnits(Integer minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        public final Integer getMaxUnits() {
            return maxUnits;
        }

        public final void setMaxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
        }

        @Override
        public final Builder maxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
