/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;

public class ListCreateAccountStatusIterable
implements SdkIterable<ListCreateAccountStatusResponse> {
    private final OrganizationsClient client;
    private final ListCreateAccountStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCreateAccountStatusIterable(OrganizationsClient client, ListCreateAccountStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCreateAccountStatusResponseFetcher();
    }

    public Iterator<ListCreateAccountStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCreateAccountStatusResponseFetcher
    implements SyncPageFetcher<ListCreateAccountStatusResponse> {
        private ListCreateAccountStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListCreateAccountStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCreateAccountStatusResponse nextPage(ListCreateAccountStatusResponse previousPage) {
            if (previousPage == null) {
                return ListCreateAccountStatusIterable.this.client.listCreateAccountStatus(ListCreateAccountStatusIterable.this.firstRequest);
            }
            return ListCreateAccountStatusIterable.this.client.listCreateAccountStatus((ListCreateAccountStatusRequest)((Object)ListCreateAccountStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

