/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOrganizationalUnitRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DeleteOrganizationalUnitRequest.Builder, DeleteOrganizationalUnitRequest> {
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(DeleteOrganizationalUnitRequest::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNIT_ID_FIELD));

    private final String organizationalUnitId;

    private DeleteOrganizationalUnitRequest(BuilderImpl builder) {
        super(builder);
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the
     * <a>ListOrganizationalUnitsForParent</a> operation.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
     * "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string
     * is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
     * </p>
     * 
     * @return The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from
     *         the <a>ListOrganizationalUnitsForParent</a> operation.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string
     *         requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
     *         OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or
     *         digits.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOrganizationalUnitRequest)) {
            return false;
        }
        DeleteOrganizationalUnitRequest other = (DeleteOrganizationalUnitRequest) obj;
        return Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOrganizationalUnitRequest").add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOrganizationalUnitRequest, T> g) {
        return obj -> g.apply((DeleteOrganizationalUnitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteOrganizationalUnitRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the
         * <a>ListOrganizationalUnitsForParent</a> operation.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
         * "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This
         * string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
         * </p>
         * 
         * @param organizationalUnitId
         *        The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from
         *        the <a>ListOrganizationalUnitsForParent</a> operation.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string
         *        requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains
         *        the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or
         *        digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOrganizationalUnitRequest model) {
            super(model);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOrganizationalUnitRequest build() {
            return new DeleteOrganizationalUnitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
